clearvars
close all

date_string = '20210529';
fpath = ['.\results_theory\',date_string,'\'];
figpath = '.\paper\figs\';

Tplot = 300;
% distancing parameters
TR_target = 0.9;  
TR_relax = 1.5;
weeks_R0 = 2;
weeks_dist_fall = 3;
weeks_dist_keep = 8;
weeks_dist_rise = 3;
% vaccination parameters
frac_vacc_H = 0.75;
weeks_vacc_H = 12;
frac_vacc_L = 0.5;
weeks_vacc_L = 8;
eff_vacc = 0.95;
wbeg_vacc = weeks_R0 + weeks_dist_fall + weeks_dist_keep/2 + 0*weeks_dist_rise + 1;

fname = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
        '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W',...
        '_vacc_pct',num2str(frac_vacc_H*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_', num2str(weeks_vacc_H),'W'];
results_fracH = load([fpath, 'multigroup_L5_',fname]);

fname = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
        '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W',...
        '_vacc_pct',num2str(frac_vacc_L*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_', num2str(weeks_vacc_L),'W'];
results_fracL = load([fpath, 'multigroup_L5_',fname]);

%%
dcT_plot = [results_fracH.dcT_avg; results_fracL.dcT_avg];
[h1,hl] = fn_plot_theory_dc(dcT_plot, Tplot);
hl.String = {'75% vaccinated over 12 weeks','50% vaccinated over 8 weeks'};

fprintf('75 percent: cmax = %.2f, Tend = %.0f days.\n', results_fracH.results(1)/100, results_fracH.results(4))
fprintf('50 percent: cmax = %.2f, Tend = %.0f days.\n', results_fracL.results(1)/100, results_fracL.results(4))

%%
figname = ['theory_cmp_vacc_PCT_dist_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_dcT'];
saveas(h1,[figpath, figname,'.png'])
