% generate contact matrix
clearvars 
close all

N = 10000;
L = 5;
path_write = '.\data_temp\';
if ~exist(path_write,'dir')
    mkdir(path_write)
end

fname = ['.\data_raw\Germany_contact_L',num2str(L),'.csv'];
data_contact = readtable(fname,'PreserveVariableNames',true);
K = data_contact(1:L,2:L+1);
K = K{:,:};

fname = ['.\data_raw\Germany_population_L',num2str(L),'.csv'];
data_pop = readtable(fname,'PreserveVariableNames',true);
pop = data_pop.population;
case_ratio = data_pop.case_ratio;

% construct reciprocal contanct matrix
K_rec = (K.*pop + K'.*pop')./(2*pop);

w = pop./sum(pop);
pop_sim_most = round(N.*w(1:end-1));
pop_sim_last = N - sum(pop_sim_most);  % assign leftovers to the last group 
pop_sim = [pop_sim_most; pop_sim_last];

Pmtx = K_rec./ ( repmat(pop_sim',L,1) - eye(L) );  % diagonal entries = p/(nl-1)
if norm(Pmtx-Pmtx')>1e-4  % check symmetry
    error('Pmtx need to be symmetric')
end

tau_ratio = case_ratio./sum(K_rec.*w',2);
tau_ratio = tau_ratio./tau_ratio(1); % normalization

%% save data
writematrix(K_rec, [path_write,'Germany_K_rec.csv']) % for writing latex
fname_write = [path_write,'Germany_contact_',num2str(L),'_groups'];
save(fname_write, 'K_rec','w','pop_sim','Pmtx','tau_ratio')

