function [CT, IT, RT, x_end, y_end] = fn_sim_empirical_each_iter...
    (betaT, N, x_ini, y_ini, choice_network, k_mean, kmin, kmax, exponent)
% x_ini and y_ini: N by 1
% x_end and y_end: N by 1

gamma = 1/14;
m = 0.001*N;   % number of initially affected individuals
T = length(betaT);
tauT = betaT./k_mean;
p = k_mean/(N-1);

CT = zeros(1,T); IT = zeros(1,T); RT = zeros(1,T);
xNT = zeros(N,T); yNT = zeros(N,T); 

if isempty(x_ini)  % start from the outbreak
    CT(1) = m;
    IT(1) = CT(1); 
    RT(1) = 0;
    x1_idx = randperm(N,m);
    xNT(x1_idx,1) = 1;
else
    xNT(:,1) = x_ini;
    yNT(:,1) = y_ini;
    CT(1) = sum(xNT(:,1)); 
    IT(1) = sum(xNT(:,1).*(ones(N,1)-yNT(:,1)));
    RT(1) = CT(1)-IT(1);
end    
xstarNT = zeros(N,T);
history = zeros(N,T); 
history(xNT(:,1)==1,1) = 1;
days_recovery_mtx = zeros(N,T);
muN = ones(N,1);

% =========== random draws ================
kxiNT = -log(1-rand(N,T));
kxiNT = kxiNT./sum(kxiNT).*N;
recover_draw = rand(N,T)<gamma;  

% ========= start the dynamic process ============
for t=2:T
    idx_ill = history(:,t-1)>0;
    xNT(idx_ill, t) = 1;
    idx_healthy = ones(N,1) - idx_ill;

    yNT(:,t) = yNT(:,t-1) + (1-yNT(:,t-1)).*xNT(:,t-1).*recover_draw(:,t);

    switch choice_network
        case 1   % ER random graph
            [D,nEdge] = fn_gen_ER_graph(N, p);             
        case 2   % power law
            [kseq,kmean_target] = fn_gen_PowLaw(N,exponent,kmin,kmax);
            [G,D] = fn_gen_Config_graph(kseq);
    end                
    xstarNT(:,t) = tauT(t).* (D * (xNT(:,t-1).*(1-yNT(:,t-1)))) - muN.*kxiNT(:,t);

    idx_infected = double(xstarNT(:,t)>0);
    idx_newill = idx_healthy.*idx_infected;
    xNT(:,t) = idx_newill + idx_ill;
    history(:,t) = history(:,t-1) + idx_ill + idx_newill;
    days_recovery_mtx(:,t) = history(:,t-1).*yNT(:,t).*(1-yNT(:,t-1));      

    CT(t) = sum(xNT(:,t));           
    IT(t) = sum(xNT(:,t).*(ones(N,1)-yNT(:,t)));
    RT(t) = CT(t) - IT(t);        

    if IT(t)==0  % skip to next iteration if epidemic ends
        CT(t+1:T) = CT(t);
        RT(t+1:T) = RT(t);
        break
    end
end

x_end = xNT(:,t);
y_end = yNT(:,t);