function h = fn_plot_theory_TR(TR, Tplot)

h = figure;
colormap = get(groot,'defaultAxesColorOrder');
plot(1:Tplot,TR(1:Tplot),'Linewidth',2,'Color', colormap(4,:))
hold on;
plot(1:Tplot,ones(1,Tplot),':','Color',ones(1,3)*150/255,'Linewidth',1.5) 
hold off;
ylabel('${\beta_t}/{\gamma}$','Interpreter','Latex','Color','black')
xlabel('Days since the outbreak','Color','black')
box('off')
set(gca,'TickDir','out'); 
ax = gca;
xticks(linspace(0,Tplot,11))
set(gca,'fontsize',12)
ax.LineWidth = 1.2;
xtickangle(90)
ylim([0,3])

end