function h = fn_plot_empirical_Re(tmax, ReT)

Tplot = length(ReT);
tmin = tmax - Tplot + 1;
h = figure;
plot(tmin:tmax,ReT,'Linewidth',2);
hold on;
plot(tmin:tmax, ones(1,Tplot),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
box('off')
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xlim([tmin,tmax])
xticks(tmin:21:tmax)
xtickformat('MMM dd')
xtickangle(90)
ylim([0,3])

end