function fn_mark_lockdown(date_start, date_end, tmin, t_ini, ReT, country)

Tplot = length(ReT);
FormatTime = 'mm/dd';
mycolor = get(groot,'defaultAxesColorOrder');
pos = get(gca, 'Position');

% mark start date
xpos = days(date_start - (tmin - t_ini));
if month(date_start)==3 && year(date_start)==2020
    yend = ReT(1);
else
    yend = ReT(days(date_start - tmin))+ 0.02;
end
if strcmp(country,'Italy') && month(date_start)==12
    arrow_start_len = 0.5;
else
    arrow_start_len = 0.7;
end
xlim_num=[1,Tplot+t_ini];
ann_start = annotation('textarrow',...
    (xpos + abs(min(xlim_num)))/diff(xlim_num) * pos(3) + pos(1).*ones(1,2),...
    [(yend + arrow_start_len - min(ylim))/diff(ylim) * pos(4) + pos(2),...
     (yend - min(ylim))/diff(ylim) * pos(4) + pos(2)]);
if strcmp(country,'Italy') && month(date_start)==12
    ann_start.String = [datestr(date_start,FormatTime),'    '];
else
    ann_start.String = datestr(date_start,FormatTime);
end
ann_start.FontSize = 12;
ann_start.Color = mycolor(7,:);
ann_start.HeadStyle = 'vback3';

% mark end date
if days(date_end - tmin) <= Tplot  % if lockdown has ended
    xpos = days(date_end - (tmin - t_ini));
    yend = ReT(days(date_end - tmin))+ 0.02;
    arrow_start_len = 0.7;
    ann_end = annotation('textarrow',...
        (xpos + abs(min(xlim_num)))/diff(xlim_num) * pos(3) + pos(1).*ones(1,2),...
        [(yend + arrow_start_len - min(ylim))/diff(ylim) * pos(4) + pos(2),...
         (yend - min(ylim))/diff(ylim) * pos(4) + pos(2)]);
    if month(date_start)<=4 && year(date_start)==2020
        ann_end.String = ['    ', datestr(date_end,FormatTime)];
    else
        ann_end.String = datestr(date_end,FormatTime);
    end
    ann_end.FontSize = 12;
    ann_end.Color = [0,153,0]/255;
    ann_end.HeadStyle = 'vback3';
end
end
