function results = fn_estimation_empirical(country, roll_window, est_ymd, MF, path_read)

gamma = 1/14;

fname_read = [path_read, country,'.csv'];
data = readtable(fname_read);
CT = data.C;

RT = zeros(size(CT));
for t = 2:length(CT)
    RT(t) = (1-gamma).*RT(t-1) + gamma.*CT(t-1);
end
IT = CT - RT;

N = data.Pop(1);
data.Date = datetime(data.Date,'InputFormat','ddMMMyyyy');

MA_window = 7;
out_MA = fn_MA([CT,IT],MA_window);
CT_MA = out_MA(:,1);
IT_MA = out_MA(:,2);
cT_MA = CT_MA./N;
iT_MA = IT_MA./N;

dCT_MA = diff(CT_MA);
dcT_MAp = dCT_MA./N.*100000;
idx_cross1 = find(dcT_MAp>=1,1,'first'); 
idx_beg = idx_cross1 + (MA_window-1) + 1; 
date_beg_betahat = data.Date(idx_beg+1); 

idx_beg_MA = idx_beg - MA_window + 1;                                        
cT_MA_use = cT_MA(max(idx_beg_MA-roll_window,0)+1:end);
iT_MA_use = iT_MA(max(idx_beg_MA-roll_window,0)+1:end);
T = length(cT_MA_use);

date_end_betahat = datetime(est_ymd,'ConvertFrom','yyyymmdd');
T_roll = days(date_end_betahat-date_beg_betahat+1);
if idx_beg_MA-roll_window<0
    T_roll = T_roll+idx_beg_MA-roll_window; 
end
betahat_rollT = zeros(T_roll,1);

yT = (1 - MF.*cT_MA_use(2:T))./(1 - MF.*cT_MA_use(1:T-1));
xT = MF.*iT_MA_use(1:T-1);
model_beta = @(b,x)( exp(-b.*x));
beta_ini = 0.2;
for t=1:T_roll
    Y = yT(t:t+roll_window-1);
    X = xT(t:t+roll_window-1);
    [betahat,uhat,J,CovB,MSE,ErrorModelInfo] = nlinfit(X,Y,model_beta,beta_ini);
    betahat_rollT(t) = betahat;     
end

results.betahat_rollT = betahat_rollT;
results.idx_beg = idx_beg;
results.date_beg_betahat = date_beg_betahat;
results.cT_MA = cT_MA;
results.Date = data.Date;
results.Re = (1 - MF.*cT_MA(end-length(betahat_rollT)+1:end)).*betahat_rollT./gamma;

end
