function [betahat_rollT, idx_nonconvg] = fn_est_beta(cT,iT,roll_window,MF)
% rolling estimation of beta
% cT: T by 1
T = length(cT);
T_roll = T-1-roll_window+1;
betahat_rollT = NaN(T_roll,1);
idx_nonconvg = [];

yT = (1 - MF.*cT(2:T))./(1 - MF.*cT(1:T-1));
xT = MF.*iT(1:T-1);
model_beta = @(b,x)( exp(-b.*x));
beta_ini = 0.2;
for t=1:T_roll
    Y = yT(t:t+roll_window-1);
    X = xT(t:t+roll_window-1);
    if std(Y)==0
        idx_nonconvg = [idx_nonconvg; t]; 
        continue
    end
    [betahat,uhat,J,CovB,MSE,ErrorModelInfo] = nlinfit(X,Y,model_beta,beta_ini);
    betahat_rollT(t) = betahat;     
end

end