function MF = fn_compute_MF(iT_cal, cT_tilde, beta)
% cT_tilde: Wm+1 by 1
% iT_cal: nsimul by Wm+1
% beta: Wm+1 by 1

bi = mean(exp(-beta(1:end-1)'.*iT_cal(:,1:end-1))); % 1 by Wm
p = mean(1 - bi);
q = mean(cT_tilde(2:end) - bi'.*cT_tilde(1:end-1));
MF = p/q;

end