*==========================================================================
* 	Date : October 2021
* 	Author: Nino Buliskeria
* 	Paper: "Do Rural Banks Matter That Much? Burgess and Pande (2005) 
*			Reconsidered" by Nino Buliskeria and Jaromir Baxa. 
*
* 	The original code is from:
*			Burgess, R., & Pande, R. (2005). 
*			"Do rural banks matter? 
*					evidence from the Indian social banking experiment."
*			American Economic Review, 95(3)
*
* 	This code replicates Burgess and Pande (2005) 
*
*===============================================================================

***Changes by N.Buliskeria:

*	I slightly adjusted the code so that it would run. 
*	Adjustments are as follows: 
*			3aster >> symbol(***, **, *) 
*			outreg >> outreg2

*	instead of regressing on ubt61 (as said in the paper) BP regressed on ubt71. 
*	reg h1 runbfor ubt77 ubdum90 popt77 popt90 popdum90 rursht77 rursht90 rurshd90 stint77 stint90 stindum90 stdum* yrdum*
*	
*	
*	Original do file from BP had no codes for plots and figures, 
*	therefore I added them. 
*===============================================================================


*# delimit
*capture clear
*cap log close

*cap log using  "burgesspandeaerregressions.log", replace

clear all 
*set more off

use "burgesspandeaerfinal.dta"

* generate the coefficients for the Figures

drop if year>2000

*Figure 1: rural branches in unbanked locations (with controls)

areg runbfor unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)

*Start NB
mata: b=st_matrix("e(b)")'
getmata b, force
gen temp=b[_n-1]
replace b=temp
replace b=. if _n==_N
replace b = . if state > 1

label variable b "rural branches in unbanked locations (with controls)"

*For the regressions we drop Haryana before 1965
*drop if state==5 & year<1965

macro define controls "popt61 popt77 popd77 popt90 popdum90 rursht61 rursht77 rurshd77 rursht90 rurshd90  stint61 stint77 stin77d stint90 stindum90"
reg runbfor ubt61 ubt77 ubt90  ubdum77 ubdum90 $controls stdum* yrdum*,cluster(state)
mata: coef=st_matrix("e(b)")'
getmata coef, force
replace coef=. if _n>5
gen gamma1 = coef[1]
gen gamma2 = coef[2]
gen gamma3 = coef[3]
gen gamma4 = coef[4]
gen gamma5 = coef[5]

gen tr =  gamma1*ubt61 + gamma2*ubt77 + gamma3*ubt90 + gamma4*ubdum77 + gamma5*ubdum90
egen trend_m = mean(tr), by (year)
gen mtrend = trend_m if state == 1
gen trend = mtrend - mtrend[1]

label variable trend "rural branches in unbanked locations (trend break)"


line b trend year , legend(size(small) cols(1) symxsize(7)) lpattern(solid longdash_dot) lcolor(black black) ///
ylabel(, labsize(small) angle(horizontal)) xlabel(, labsize(small)) graphregion(color(white)) xtitle("")  ///
ytitle("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", size(small)) 

graph export "Figure1.eps", as(eps) replace


*Figure 2: rural credit share
areg rurcrsh unbk70-unbk00 rshare70-rshare00 popn70-popn00 stin70-stin00 stdum*, absorb(year) cluster(state)

coefplot, noci ///
keep(unbk62 unbk63 unbk64 unbk65 unbk66 unbk67 unbk68 unbk69 unbk70 ///
unbk71 unbk72 unbk73 unbk74 unbk75 unbk76 unbk77 unbk78 unbk79 unbk80 unbk81 ///
unbk82 unbk83 unbk84 unbk85 unbk86 unbk87 unbk88 unbk89 unbk90 unbk91 unbk92 ///
unbk93 unbk94 unbk95 unbk96 unbk97 unbk98 unbk99 unbk00) yline(0) vertical  ///
coeflabels(unbk62 = " " unbk63 = " " unbk64 = " " unbk65 = "1965" /// 
unbk66 = " " unbk67 = " " unbk68 = " " unbk69 = " " unbk70 = "1970" ///
unbk71 = " " unbk72 = " " unbk73 = " " unbk74 = " " unbk75 = "1975" ///
unbk76 = " " unbk77 = " " unbk78 = " " unbk79 = " " unbk80 = "1980" ///
unbk81 = " " unbk82 = " "  unbk83 = " "  unbk84 = " "  unbk85 = "1985"  ///
unbk86 = " "  unbk87 = " "  unbk88 = " "  unbk89 = " "  unbk90 = "1990" ///
unbk91 = " "  unbk92 = " " unbk93 = " "  unbk94 = " "  unbk95 = "1995"  ///
unbk96 = " "  unbk97 = " "  unbk98 = " "  unbk99 = " "  unbk00 = "2000" ) ///
legend(order( 1 "rural credit share") on) legend(size(small)  symxsize(7)) /// 
ylabel(, labsize(small) angle(horizontal)) lpattern(longdash_dot) lcolor(black) ///   
xlabel(, labsize(small)) ytitle("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", size(small)) ///
recast(line) ciopts(recast(rline) lpattern(dash))  graphregion(color(white)) xtitle("") 
*title(Figure 2. Initial Financial Development and Rural Bank Credit Share, size(small))

graph export "Figure2.eps", as(eps) preview(off) replace
graph export "Figure2.png", as(eps) preview(off) replace

*Figure 3: Poverty
areg h1 unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)
estimates store rural 
areg h2 unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)
estimates store urban 

coefplot (rural, noci label(rural) lpattern(solid)) (urban, noci label(urban) lpattern(longdash_dot)), ///
keep(unbk62 unbk63 unbk64 unbk65 unbk66 unbk67 unbk68 unbk69 unbk70 			///
unbk71 unbk72 unbk73 unbk74 unbk75 unbk76 unbk77 unbk78 unbk79 unbk80 unbk81    ///
unbk82 unbk83 unbk84 unbk85 unbk86 unbk87 unbk88 unbk89 unbk90 unbk91 unbk92    ///
unbk93 unbk94 unbk95 unbk96 unbk97 unbk98 unbk99 unbk00) yline(0) vertical      ///
coeflabels(   unbk62 = " "  unbk63 = " "  unbk64 = " "  unbk65 = "1965" 		///
unbk66 = " "  unbk67 = " "  unbk68 = " "  unbk69 = " "  unbk70 = "1970" 		///
unbk71 = " "  unbk72 = " "  unbk73 = " "  unbk74 = " "  unbk75 = "1975" 		///
unbk76 = " "  unbk77 = " "  unbk78 = " "  unbk79 = " "  unbk80 = "1980" 		///
unbk81 = " "  unbk82 = " "  unbk83 = " "  unbk84 = " "  unbk85 = "1985" 		///
unbk86 = " "  unbk87 = " "  unbk88 = " "  unbk89 = " "  unbk90 = "1990" 		///
unbk91 = " "  unbk92 = " "  unbk93 = " "  unbk94 = " "  unbk95 = "1995"  		///
unbk96 = " "  unbk97 = " "  unbk98 = " "  unbk99 = " "  unbk00 = "2000") 		///
legend(order( 1 "rural headcount ratio" 2 "urban headcount ratio") on) legend(size(small)  symxsize(7)) ///
ylabel(, labsize(small) angle(horizontal)) lcolor(black black) ///
xlabel(, labsize(small)) ytitle("Initial financial development X year - coefficient {it}{&lambda}{subscript:t}", size(small))  ///
recast(line) ciopts(recast(rline) lpattern(dash)) graphregion(color(white)) xtitle("") 
*title(Figure 3. Initial Financial Development and Poverty, size(small)) 

graph export "Figure3.eps", as(eps) preview(off)  replace
graph export "Figure3.png", as(eps) preview(off)  replace

*For the regressions we drop Haryana before 1965
drop if state==5 & year<1965

*Table 1: Banking as a Function of Initial financial development

macro define controls " popt61 popt77 popd77 popt90 popdum90 rursht61 rursht77 rurshd77 rursht90 rurshd90  stint61 stint77 stin77d stint90 stindum90"

local table1outcomes "  rurcrsh rursavsh bfor priorsh pcoopsh"

reg runbfor ubt61 ubt77 ubt90   ubdum77 ubdum90 $controls stdum* yrdum*,cluster(state)

test ubt61+ubt77=0
local F1 = r(F) 
local p1 = r(p) 

test ubt61+ubt77+ubt90=0

outreg2 using "table_1.tex", se addtext(State and year dummies, YES, Other controls, YES) ///
keep(ubt61 ubt77 ubt90 ubdum77 ubdum90) addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace

*outreg2 using "table_1.tex", se  coefastr  bracket bdec(2) adjr2 symbol(***, **, *) nolabel nocons replace

foreach v of local table1outcomes {
reg `v' ubt61 ubt77 ubt90   ubdum77 ubdum90 $controls stdum* yrdum*, cluster(state)
test ubt61+ubt77=0
local F1 = r(F) 
local p1 = r(p) 

test ubt61+ubt77+ubt90=0

outreg2 using "table_1.tex", se addtext(State and year dummies, YES, Other controls, YES) ///
keep(ubt61 ubt77 ubt90 ubdum77 ubdum90) addstat(F-test 1,`F1', P1 , `p1', F-test 2,`r(F)', P2,`r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons append 

}

*Table 2:  Bank Branch Expansion and Poverty: Reduced Form
local table2outcomes " h2 head lrwagenew lsalpw"
reg h1 ubt61 ubt77 ubt90 ubdum77 ubdum90 $controls stdum* yrdum*, cluster(state)
test ubt61+ubt77=0

local F12 = r(F)
local p12 = r(p)

test ubt61+ubt77+ubt90=0

outreg2 using "table_2.tex", se addtext(State and year dummies, YES, Other controls, YES) ///
keep(ubt61 ubt77 ubt90 ubdum77 ubdum90) addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)')  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons replace

foreach v of local table2outcomes {
 reg `v' ubt61 ubt77 ubt90   ubdum77 ubdum90 $controls stdum* yrdum*, cluster(state)
test ubt61+ubt77=0
test ubt61+ubt77=0

local F12 = r(F)
local p12 = r(p)

test ubt61+ubt77+ubt90=0

outreg2 using "table_2.tex", se addtext(State and year dummies, YES, Other controls, YES) ///
keep(ubt61 ubt77 ubt90 ubdum77 ubdum90) addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons append

}

*Table 3: Poverty IV estimates
local table3 "h1 h2 head lrwagenew lsalpw"

reg h1 runbfor stdum* yrdum*, cluster(state)

outreg2 using "table_3.tex", se keep(runbfor) coefastr  paren bdec(2) adjr2 symbol(***, **, *) ///
nolabel nocons addtext(State and year dummies, YES, Other controls, YES) replace

reg h1 runbfor ubt61 ubdum77 ubdum90 $controls  stdum* yrdum*, cluster(state)

outreg2 using "table_3.tex", se  keep(runbfor ubt61 ubdum77 ubdum90)  coefastr  ///
paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

foreach v of local table3 {
reg `v'  runbfor ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
(ubt77 ubt61 ubdum77 ubt90 ubdum90  $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_3.tex", se keep(runbfor ubt61 ubdum77 ubdum90) coefastr  ///
paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

}

*restricted sample for h1
reg h1 runbfor ubt61 ubdum77  popt61 popt77 popd77 rursht61 rursht77 rurshd77 stint61 stint77 stin77d stdum* yrdum* ///
(ubt77 ubt61 ubdum77   popt61 popt77 popd77 rursht61 rursht77 rurshd77  stint61 stint77 stin77d  stdum* yrdum* ) if year<1990, cluster(state)

outreg2 using "table_3.tex", se keep(runbfor ubt61 ubdum77) coefastr paren bdec(2) adjr2 symbol(***, **, *) ///
nolabel nocons addtext(State and year dummies, YES, Other controls, YES) append

** adjusted code to match text and table 3, peresented in the main text in Burgess and Pande (2005)
reg h1 runbfor ubt61 ubdum77  ubdum90  $controls stdum* yrdum* (ubt77 ubt61 ubdum77 ubt90 ubdum90  $controls stdum* yrdum* ) if year>1976, cluster(state)

outreg2 using "table_3.tex", se keep(runbfor ubt61 ubdum77  ubdum90) coefastr  paren bdec(2) adjr2  symbol(***, **, *) ///
nolabel nocons addtext(State and year dummies, YES, Other controls, YES) append

// reg h1 runbfor ubt77 ubdum90 popt77 popt90 popdum90  rursht77 rursht90 rurshd90  stint77 stint90 stindum90 stdum* yrdum* ///
// (ubt90 ubt77 ubdum90 popt77 popt90 popdum90  rursht77 rursht90 rurshd90  stint77 stint90 stindum90 stdum* yrdum* ) if year>1976, cluster(state)
//
// outreg2 using "table_3.tex", se keep(runbfor ubt61 ubdum90) coefastr  paren bdec(2) adjr2 symbol(***, **, *) ///
// nolabel nocons addtext(State and year dummies, YES, Other controls, YES) append

reg h1 runbfor ubt61 ubdum77  ubdum90  $controls stdum* yrdum* (ubt77 ubt61 ubdum77 ubt90 ubdum90  $controls stdum* yrdum* ) if round~=.,cluster(state)

outreg2 using "table_3.tex", se keep(runbfor ubt61 ubdum77  ubdum90) coefastr  paren bdec(2) adjr2  symbol(***, **, *) ///
nolabel nocons addtext(State and year dummies, YES, Other controls, YES) append



capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

*Table 4: rural credit and savings
local table4outcomes " h2 head "

reg h1  rurcrsh ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
(ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  keep(rurcrsh ubt61 ubdum77 ubdum90)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

reg h1  rursavsh ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
(ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  keep(rursavsh ubt61 ubdum77 ubdum90)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob
foreach v of local table4outcomes {
reg `v'  rurcrsh ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
(ubt77 ubt61 ubdum77 ubt90 ubdum90  $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  keep(rurcrsh ubt61 ubdum77 ubdum90)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

reg `v' rursavsh ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
(ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  keep(rursavsh ubt61 ubdum77 ubdum90)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

}
*Table 5: robustness
macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"

reg h1  runbfor $policy  ubt61 ubdum77 ubdum90  $controls stdum* yrdum* ///
($policy ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  keep(runbfor $policy)  coefastr  paren ///
bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob



reg h1  runbfor $policy  $politics ubt61 ubdum77 ubdum90  $controls stdum* yrdum* ///
($policy $politics ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  keep(runbfor $policy $politics )  coefastr  ///
paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

reg h2  runbfor $policy  ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
($policy ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  keep(runbfor $policy)  coefastr  ///
paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob

reg h2  runbfor $policy $politics ubt61 ubdum77 ubdum90 $controls stdum* yrdum* ///
($policy $politics ubt77 ubt61 ubdum77 ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  keep(runbfor $policy $politics)  coefastr  ///
paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append


capture drop resinc

predict resinc, res

reg resinc  ubt77 ubt90, noc robust  

capture drop sargan

ge sargan=_result(7)*_result(1)

capture drop prob

ge prob=chiprob(3,sargan)

disp sargan prob
