*==========================================================================
* Date : October 2021
* Author: Nino Buliskeria
* Paper: Do Rural Banks Matter That Much? Burgess and Pande (2005) Reconsidered
*			by Nino Buliskeria and Jaromir Baxa. 

* This code allows to replicates:
*		 Burgess, R., & Pande, R. (2005). 
*		"Do rural banks matter? 
*					evidence from the Indian social banking experiment."
*		American Economic Review, 95(3)
*
* This code also offers possibility to extend instrumental variables 
* excersise presented in Burgess and Pande (2005) by introducing additional 
* cut-years when summarizing the rural bank branch opening trend reversal. 
*
*------------------------------------------------------------------------------
* 
* First choose the cut-years of interest 
* 			- global years 77 90 - 
* 			or any other combination up to 10 cut years.
* 			The cut years are named alphabethically - A B C D E F G H I J; 
* 	 		In this case "A" would be 1977 and "B" - 1990. 
*
* Next, allow for joint F test for the combination of cut-years.
* 			In this case: 
* 	       	- global test "ubtA + ubtB" - 
*	 		If you would choose 5 cut-years, joint test would be:  
*	 		   - global test "ubtA+ubtB+ubtC+ubtD+ubtE+ubtF" -
*	 		here, letters are names for respective cut-years.
*==========================================================================
clear all 
macro drop _all 
*------------------------------------------------------------------------------
*load data
use "burgesspandeaerfinal.dta"
drop if year>2000
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
// The cut-years are named alphabethically, first being A, up to J. 
global manes A B C D E F G H I J	
*------------------------------------------------------------------------------


*_________________________________________EDIT HERE: __________________________
*											 Choose cut-years (no more then 10, 
*													write last two numbers of the year))
*											 Burgess and Pande (2005):
												*global years 77 90  
*											 Historic years:
												*global years 67 72 77 80 85 90 
											 *Bai & Perron test:
												global years 68 73 79 84 89

*______________________________________________________________________________
			
	
*==============================================================================	
//STEP 1: Variables:
*------------------------------------------------------------------------------
*Generate Control Dummy Variables
do 1_genVariables

*------------------------------------------------------------------------------
*------------------------------------------------------------------------------
*Define Control Variables:
do 1_defGlobal

*------------------------------------------------------------------------------
*==============================================================================

*_________________________________________EDIT HERE:__________________________

*											Add coeffs for joint F-test of ubt* in the following form:
*											Burgess and Pande (2005):
												*global test "ubtA +	ubtB" 
							
*											Historic years:
												*global test "ubtA + ubtB  + ubtC +	ubtD +	ubtE +	ubtF"
*											Bai & Perron test:
												global test "ubtA + ubtB  + ubtC +	ubtD +	ubtE"
*______________________________________________________________________________







*==============================================================================	
// STEP 2: Figrues 
*------------------------------------------------------------------------------	
*Generate Figure 1: 
do 2_Figure1
*==============================================================================			
		
	
*==============================================================================		
//STEP 3: Regressions:
*------------------------------------------------------------------------------	
*For the regressions Burgess and Pande (2005) drop Haryana before 1965:
drop if state==5 & year<1965

*------------------------------------------------------------------------------	
//Table1: BANKING AS A FUNCTION OF INITIAL FINANCIAL DEVELOPMENT
do 3_Table1
*seeout using "table_1.txt"
*------------------------------------------------------------------------------
*------------------------------------------------------------------------------

//Table2: BANK BRANCH EXPANSION AND POVERTY: REDUCED FORM EVIDENCE
do 3_Table2
*seeout using "table_2.txt"

*------------------------------------------------------------------------------
*------------------------------------------------------------------------------
//Table3: BANK BRANCH EXPANSION AND POVERTY: INSTRUMENTAL VARIABLES EVIDENCE

*__________________________________________________EDIT HERE:_________________

*													choose value for "Tr" - 
*														sample restriction for Table 3, column 7.
*													(after treatment period T - 1 )
*													Burgess and Pande (2005):
														*scalar Tr = 1976 
*													Historic years:
														scalar Tr = 1966 
*______________________________________________________________________________
do 3_Table3
*seeout using "table_3.txt"
*------------------------------------------------------------------------------
*------------------------------------------------------------------------------
//Table4: RURAL CREDIT AND SAVINGS AND POVERTY: INSTRUMENTAL VARIABLES EVIDENCE
do 3_Table4
*seeout using "table_4.txt"

*------------------------------------------------------------------------------
*------------------------------------------------------------------------------
//Table5: BANK BRANCH EXPANSION AND POVERTY REDUCTION: ROBUSTNESS CHECKS
do 3_Table5
*seeout using "table_5.txt"
*------------------------------------------------------------------------------
*==============================================================================		
