
	clear all 

*Yearly data 
	use "burgesspandeaerfinal.dta"
	drop if year>2000
	sort year

*Deflator
	by year: egen yscpial1u = mean(scpial1u)
	by year: egen ystcpiw1u = mean(stcpiw1u)

*Population by state 
	by year: egen ypop61 = total(pop61)
	gen popt = pop1 + pop2

*Population - India 
	by year: egen ypop1 = total(pop1)
	by year: egen ypop2 = total(pop2)
	gen ypopt = ypop1 + ypop2

*Poverty - Number of poor by state 
	gen poor1 = h1*pop1
	gen poor2 = h2*pop2
	gen poor = poor1 + poor2

*Poverty - Number of Poor in India
	by year: egen ypoor1 = total(poor1)
	by year: egen ypoor2 = total(poor2)
	by year: egen ypoor = total(poor)
	
*Headcount Ratio - India 
	gen yhead = ypoor/ypopt
	gen yh1 = ypoor1/ypop1
	gen yh2 = ypoor2/ypop2

	label variable yh1   "Rural Headcount Ratio"
	label variable yh2 	 "Urban Headcount Ratio"
	label variable yhead "Cumulative Headcount Ratio"
	*line yhead yh1 yh2 year if state == 1

*Domestic Product 
	by year: egen ynsdp = total(nsdp) // nominal net domestic product
	gen ydeflate = (ypop2/(ypop1+ypop2))*ystcpiw1u+(ypop1/(ypop1+ypop2))*yscpial1u
	quietly ipolate ynsdp year, gen(ynsdpx) 
		replace ynsdpx=. if year>1997
		replace ynsdpx=. if year<1960
	gen ystinc= (100*ynsdpx)/((ypop61)*ydeflate)

	label variable ydeflate "deflator"
	label variable ystinc   "real per capita net domestic product"
	*line ystinc year

*Banks 
	by year: egen ybankcr = total(bankcr) //  real per-capita total bankcredit, India
	by year: egen yall1 = total(all1)
	by year: egen ybank1 = total(bank1)
	by year: egen yunbank1 = total(unbank1)
	by year: egen yruunb1 = total(ruunb1)

	label variable yall1 "Cumulative BBs opened, India"
	label variable ybank1 "Cumulative BBs opened in banked locations, India"
	label variable yunbank1 "Cumulative BBs opened in unbanked locations, India"
	label variable yunbank1 "Cumulative BBs opened in rural unbanked locations, India"
	*line  yall1 ybank1 yunbank1 year if state == 1

* Figure 2a. Population-to-rural bank ratio by state
*Density State 
	sort state 
	gen popt1981 = popt if year == 1981
		by state: egen popt81 = max(popt1981)
	gen rden81 = popt81/unbank1
	label variable rden81 "Population-to-rural bank ratio with 1981 population"

* Plot Figure 2a.
	xtline rden81, t(year) i(statenm) overlay legend(size(vsmall) cols(4))  ///
	ytitle(Population in thousands, size(small)) yline(20, style(extended) lpattern(longdash) lcolor(Black)) ///
	ylabel(,labsize(small) angle(horizontal)) ymlabel(20, angle(horizontal)) plot1(lc(Black)) ///
	xtitle(" ")  xlabel(, labsize(small)) xtitle(, size(small)) graphregion(color(white)) 
	graph export "F2a.eps", as(eps) replace

*Figure 2b. Population-to-bank ratio in India
* Density India 
	sort yall1 year state
	gen   ypopt1981 = ypopt if year == 1981
		egen  ypopt81 = max(ypopt1981)
	gen   yden81 = ypopt81/yall1 	// number of individuals per bank in India 
	gen   yrden81 = ypopt81/yunbank1
	label variable yden81   "total density"
	label variable yrden81  "rural density"

* Plot Figure 2b
	line yrden81 yden81 year if state == 1, legend(size(small) cols(4)) ///
	ytitle(Population in thousands, size(small)) yline(20, lpattern(vshortdash) lcolor(Black)) ///
	lpattern(longdash_dot solid) ylabel(,labsize(small) angle(horizontal)) ///
	xlabel(, labsize(small)) xtitle(, size(small)) lcolor(Black Black) ///
	xtitle(" ")  graphregion(color(white)) 

	graph export "F2b.eps", as(eps) replace








