*==========================================================================
* Date : October 2021
* Paper: Do Rural Banks Matter That Much? Burgess and Pande (2005) Reconsidered
* The original code is from:
*		 Burgess, R., & Pande, R. (2005). 
*		"Do rural banks matter? 
*					evidence from the Indian social banking experiment."
*		American Economic Review, 95(3)
* This code replicates Burgess and Pande (2005) with different cut-years 
* substituted for 1977. 
*==========================================================================

clear all 
*set more off
use "burgesspandeaerfinal.dta"
*------------------------------
*===========================================================================
*===========================================================================
*							 SECTION 1: replicate FIGURE 1 
*								for different cut-years. 
*===========================================================================
*===========================================================================

* generate the coefficients for the Figures
drop if year>2000

*Figure 1: rural branches in unbanked locations (with controls)
quietly areg runbfor unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)

*Save coeff of ubks
	quietly mata: b=st_matrix("e(b)")'
	quietly getmata b, force
	quietly gen temp=b[_n-1]
	quietly replace b=temp
	quietly replace b=. if _n==_N
	quietly replace b = . if state > 1
	quietly label variable b "rural branches in unbanked locations (with controls)"

local graphs ""

forvalues i = 1961(1)1996 {
gen T_`i' = `i'

	gen trend_`i' = year - (T_`i'-1)
	replace trend_`i' =0 if year < T_`i'
	gen dum_`i' =0
	replace dum_`i' =1 if year>(T_`i'-1)
	gen ubt_`i' =unb61*trend_`i' *dum_`i' 
	gen ubdum_`i' =unb61*dum_`i' 
	gen popt_`i' =((pop61)/larea)*trend_`i' *dum_`i' 
	gen popd_`i' =((pop61)/larea)*dum_`i' 
	gen stint_`i' =stinc61*trend_`i' 
	gen stind_`i' =stinc61*dum_`i' 
	gen rursht_`i' =rursh61*trend_`i' *dum_`i' 
	gen rurshd_`i' =rursh61*dum_`i' 


macro define controls "popt61 popt_`i'  popd_`i'  popt90 popdum90 rursht61 rursht_`i' rurshd_`i' rursht90 rurshd90  stint61 stint_`i' stind_`i' stint90 stindum90"

quietly reg runbfor ubt61 ubt_`i' ubt90  ubdum_`i' ubdum90 $controls stdum* yrdum*,cluster(state)

	quietly mata: coef_`i'=st_matrix("e(b)")'
	quietly getmata coef_`i', force
	quietly replace coef_`i'=. if _n>5
	quietly gen gamma1_`i' = coef_`i'[1]
	quietly gen gamma2_`i' = coef_`i'[2]
	quietly gen gamma3_`i' = coef_`i'[3]
	quietly gen gamma4_`i' = coef_`i'[4]
	quietly gen gamma5_`i' = coef_`i'[5]

quietly gen tr_`i' =  gamma1_`i'*ubt61 + gamma2_`i'*ubt_`i' + gamma3_`i'*ubt90 + gamma4_`i'*ubdum_`i' + gamma5_`i'*ubdum90

	quietly egen trend_m_`i' = mean(tr_`i'), by (year)
	quietly gen mtrend_`i' = trend_m_`i' if state == 1
	quietly gen mytrend_`i' = mtrend_`i' - mtrend_`i'[1]

	quietly label variable mytrend_`i' "rural branches in unbanked locations (trend break)"

		quietly line b mytrend_`i' year, ///
		legend(size(small) cols(1) symxsize(7)) ///
		lpattern(solid longdash_dot) lcolor(black black) ///
		ylabel(, labsize(small) angle(horizontal)) ///
		xlabel(, labsize(small)) graphregion(color(white))  ///
		xtitle(Policy introduced in `i', size(small)) ///
		saving(Figure1_`i', replace) nodraw
	
 }

local all "Figure1_1970.gph Figure1_1971.gph Figure1_1972.gph Figure1_1973.gph Figure1_1974.gph Figure1_1975.gph Figure1_1976.gph Figure1_1977.gph Figure1_1978.gph Figure1_1979.gph Figure1_1980.gph Figure1_1981.gph"

grc1leg2 `all', col(3) ///
l1("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", size(small)) 
*title(FIGURE 1. 1961 Initial Financial Development and Rural Branch Expansion, size(small))  ///

graph export all.eps, replace 




*===========================================================================
*===========================================================================
*							 SECTION 2: TABLES 
*===========================================================================
*===========================================================================



forvalues i = 1961(1)1990 {
*------------------------------
*------------------------------
* generate the coefficients for the Figures
drop if year > 2000
*For the regressions we drop Haryana before 1965
drop if state == 5 & year < 1965


*===========================================================================
*Table 1: Banking as a Function of Initial financial development
*===========================================================================


macro define controls "popt61 popt_`i' popd_`i' popt90 popdum90 rursht61 rursht_`i' rurshd_`i' rursht90 rurshd90  stint61 stint_`i' stind_`i' stint90 stindum90"

local table1outcomes "rurcrsh rursavsh bfor priorsh pcoopsh"

*Column 1: Branches in rural unbanked locations
*---------------------------------------------------------------------------
quietly reg runbfor ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90 $controls stdum* yrdum*,cluster(state)

		quietly test ubt61+ubt_`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt_`i'+ubt90=0

	outreg2 using "table_1_`i'.txt", se ///
	addtext(State and year dummies, YES, Other controls, YES) ///
	keep(ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90) ///
	addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
	coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace


*Columns 2 & 3 - Rural bank: Rural bank Credit and Savings share
*& Column 4 - Branches in banked locations
*&& Columns 5 & 6 - Credit share: Priority sector and Cooperative
*---------------------------------------------------------------------------	

foreach v of local table1outcomes {
quietly reg `v' ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90 $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt_`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt_`i'+ubt90=0

	outreg2 using "table_1_`i'.txt", se ///
	addtext(State and year dummies, YES, Other controls, YES) ///
	keep(ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90) ///
	addstat(F-test 1,`F1', P1 , `p1', F-test 2,`r(F)', P2,`r(p)') ///
	coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons append 
	
}


*===========================================================================
*Table 2:  Bank Branch Expansion and Poverty: Reduced Form
*===========================================================================

local table2outcomes " h2 head lrwagenew lsalpw"

*Column 2 - Rural Headcount Ratio 
*---------------------------------------------------------
quietly reg h1 ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90 $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt_`i'=0
		local F12 = r(F)
		local p12 = r(p)
		quietly test ubt61+ubt_`i'+ubt90=0

	outreg2 using "table_2_`i'.txt", se ///
	addtext(State and year dummies, YES, Other controls, YES) ///
	keep(ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90) ///
	addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)')  ///
	coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons replace




*Columns 3 & 4 - Urban & Aggregate Headcount Ratio 
* & Columns 5 & 6 - Agricultural & Factory wages
*---------------------------------------------------------------------------
foreach v of local table2outcomes {
	
quietly reg `v' ubt61 ubt_`i' ubt90   ubdum_`i' ubdum90 $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt_`i' = 0
		quietly test ubt61+ubt_`i' = 0
		local F12 = r(F)
		local p12 = r(p)
		quietly test ubt61+ubt_`i'+ubt90=0

	outreg2 using "table_2_`i'.txt", se ///
	addtext(State and year dummies, YES, Other controls, YES) ///
	keep(ubt61 ubt_`i' ubt90 ubdum_`i' ubdum90) ///
	addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)') ///
	coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons append
}





*===========================================================================
*Table 3: Bank Branch Expansion and Poverty: Instrumental Variables Evidence
*===========================================================================
local table3 "h1 h2 head"


*Column 1: OLS with one regressor: 
*Number branches opened in rural unbanked locations per capita
*---------------------------------------------------------------------------
quietly reg h1 runbfor stdum* yrdum*, cluster(state)

	outreg2 using "table_3_`i'.txt", se ///
	keep(runbfor) ///
	coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
	addtext(State and year dummies, YES, Other controls, YES) replace


*Column 2: OLS with additional controls 
*---------------------------------------------------------------------------
quietly reg h1 runbfor ubt61 ubdum_`i' ubdum90 $controls  stdum* yrdum*, cluster(state)

	outreg2 using "table_3_`i'.txt", se  	///
	keep(runbfor ubt61 ubdum_`i' ubdum90)  	///
	coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons 	///
	addtext(State and year dummies, YES, Other controls, YES) append


*Columns 3, 4 & 5  - IV: Rural, Urban & Aggraget Headcount Ratio 
*---------------------------------------------------------------------------
foreach v of local table3 {
quietly reg `v'  runbfor ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90  $controls stdum* yrdum* ), cluster(state)

	outreg2 using "table_3_`i'.txt", se ///
	keep(runbfor ubt61 ubdum_`i' ubdum90)  ///
	coefastr paren bdec(2)  symbol(***, **, *) nolabel nocons ///
	addtext(State and year dummies, YES, Other controls, YES) append


capture drop resinc
predict resinc, res
quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob

}




*Columns 6, 7, 8 -- restricted sample for h1 
*---------------------------------------------------------------------------

*column 6, earlier then 1990
*---------------------------------------------------------------------------
quietly reg h1 runbfor ubt61 ubdum_`i'  popt61 popt_`i' popd_`i' rursht61 rursht_`i' rurshd_`i' stint61 stint_`i' stind_`i' stdum* yrdum* /// 
(ubt_`i' ubt61 ubdum_`i' popt61 popt_`i' popd_`i' rursht61 rursht_`i' rurshd_`i'  stint61 stint_`i' stind_`i'  stdum* yrdum* ) if year < 1990, cluster(state)

outreg2 using "table_3_`i'.txt", se ///
keep(runbfor ubt61 ubdum_`i') ///
coefastr paren bdec(2) symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append



*column 7, earlier then treatment year (BP05 1976)
*---------------------------------------------------------------------------
quietly reg h1 runbfor ubt61 ubdum90 popt_`i' popt90 popdum90  rursht_`i' rursht90 rurshd90  stint_`i' stint90 stindum90 stdum* yrdum* ///
(ubt90 ubt_`i' ubdum90 popt_`i' popt90 popdum90  rursht_`i' rursht90 rurshd90  stint_`i' stint90 stindum90 stdum* yrdum* ) if year > 1976, cluster(state)

outreg2 using "table_3_`i'.txt", se ///
keep(runbfor ubt61 ubdum90)  ///
coefastr  paren bdec(2) symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append



*column 8, survey years
*---------------------------------------------------------------------------
quietly reg h1 runbfor ubt61 ubdum_`i'  ubdum90  $controls stdum* yrdum* (ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90  $controls stdum* yrdum* ) if round~=.,cluster(state)

outreg2 using "table_3_`i'.txt", se ///
keep(runbfor ubt61 ubdum_`i'  ubdum90) ///
coefastr paren bdec(2) symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob






*Columns 9 & 10  - IV: Agricultural & Factory wages
*---------------------------------------------------------------------------
local table31 "lrwagenew lsalpw"
*---------------------------------------------------------------------------
foreach v of local table31 {
quietly reg `v'  runbfor ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90  $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_3_`i'.txt", se ///
keep(runbfor ubt61 ubdum_`i' ubdum90) ///
coefastr paren bdec(2) symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob

}



*==============================================================================
*Table 4: Rural credit and Savings and Poverty: Instrumental Variables Evidence
*==============================================================================

local table4outcomes "h2 head"

*Column 1. Rural Headcount Ratio -- with Rural bank credit share
*---------------------------------------------------------------------------

quietly reg h1 rurcrsh ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4_`i'.txt", se  ///
keep(rurcrsh ubt61 ubdum_`i' ubdum90)  ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob


*Column 2. Rural Headcount Ratio -- with Rural bank savings share
*---------------------------------------------------------------------------

quietly reg h1 rursavsh ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4_`i'.txt", se  ///
keep(rursavsh ubt61 ubdum_`i' ubdum90)  ///
coefastr  paren bdec(2) symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob

*Columns 3 & 5. Urban and Aggregate Headcount Ratio -- with Rural bank credit share
*---------------------------------------------------------------------------
foreach v of local table4outcomes {
	
quietly reg `v' rurcrsh ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90  $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4_`i'.txt", se  ///
keep(rurcrsh ubt61 ubdum_`i' ubdum90)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob

*Columns 4 & 6. Urban and Aggregate Headcount Ratio -- with Rural bank savings share
*---------------------------------------------------------------------------

quietly reg `v' rursavsh ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum*  ///
(ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)


outreg2 using "table_4_`i'.txt", se ///
keep(rursavsh ubt61 ubdum_`i' ubdum90)  ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob

}




*===========================================================================
*Table 5: Bank Branch Expansion And Poverty Reduction: Robustness Checks
*===========================================================================

macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"


*Column 1. Rural Headcount Ratio -- with policy variables
*---------------------------------------------------------------------------
quietly reg h1  runbfor $policy  ubt61 ubdum_`i' ubdum90  $controls stdum* yrdum* ///
($policy ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5_`i'.txt", se  ///
keep(runbfor $policy)   ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob



*Column 2. Rural Headcount Ratio -- with policy and political variables 
*---------------------------------------------------------------------------
quietly reg h1 runbfor $policy  $politics ubt61 ubdum_`i' ubdum90  $controls stdum* yrdum* ///
($policy $politics ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5_`i'.txt", se  ///
keep(runbfor $policy $politics )    ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob


*Column 3. Urban Headcount Ratio -- with policy variables
*---------------------------------------------------------------------------
quietly reg h2  runbfor $policy  ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
($policy ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5_`i'.txt", se  ///
keep(runbfor $policy)    ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob


*Column 4. Urban Headcount Ratio -- with policy and political variables 
*---------------------------------------------------------------------------
quietly reg h2 runbfor $policy $politics ubt61 ubdum_`i' ubdum90 $controls stdum* yrdum* ///
($policy $politics ubt_`i' ubt61 ubdum_`i' ubt90 ubdum90 $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5_`i'.txt", se  ///
keep(runbfor $policy $politics)    ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res	

quietly reg resinc  ubt_`i' ubt90, noc robust  
capture drop sargan

ge sargan=_result(7)*_result(1)
capture drop prob

ge prob=chiprob(3,sargan)
disp sargan prob
}
*-------------------------------------------------------------------------------
