clear 
clc

%% Read stock index data
% Read original data
disp('read stock data ...')
data_stock = readtable('oxfordmanrealizedvolatilityindices.xlsx');
disp('read stock data completed!')
% Extract stock indices
data_stock.Symbol = strrep(data_stock.Symbol, '.', '');
stock_list  = unique(data_stock.Symbol);
for i=1:length(stock_list)
    stock_realized_data.(stock_list{i}) = data_stock(strcmp(data_stock.Symbol,stock_list{i}),:);
end

% Number of observation
NumObs = 4000;

% Realized measures to be extracted
measure_list = {'bv','rk_parzen','rk_th2','rk_twoscale','medrv','rv5'};

% Stock indexes to be extracted
data_list = {'SPX','N225','RUT','GDAXI'};

for i=1:length(data_list)
    disp(['Extract data ',data_list{i}])
    col_keep = [{'open_to_close'},measure_list];
    if(height(stock_realized_data.(data_list{i})) > NumObs)
        data_i = rmmissing(stock_realized_data.(data_list{i}));
        data_i = data_i(end-NumObs+1:end,:);  
    end
    data_save_i = data_i(:,col_keep);
    data_save_i.Properties.VariableNames{1}='return';
    
    % Write each data to a single csv file
    file_name = [data_list{i},'.csv'];
    writetable(data_save_i,file_name);
end 

%% Read currency exchange data
% Read original data
disp('read currency exchange data ...')
data_exchange = readtable('realized.library.0.1.csv');
disp('read currency exchange data completed!')

% Columns to be extracted
col_keep = {'GBP_r','GBP_rv','GBP_rk'};

% Extract USD/GBP data. Removing rows with missing values and keep only
% last 2000 rows.
NumObs = 2000;
disp('Extract data USD/GBP')
exchange_realized_data = rmmissing(data_exchange(:,col_keep));
exchange_realized_data = exchange_realized_data(end-NumObs+1:end,:);

% Write data to a csv file
writetable(exchange_realized_data,'USD_GBP.csv')

