main_path <- getwd()
fig_path <- paste0(main_path, "/figures")
# The code in "data_preparation_wide.R" creates the data object "data"
# it also writes a copy of the clean data in "data/data_clean_wide.csv"
source("data_preparation_wide.R")
source("functions.R")
data <- data_wide
rm(data_wide)
# load packages -----------------------------------------------------------

library(ARDL)
library(ggplot2)
library(lmtest) # for bgtest, resettest
library(tseries) # for jarque.bera.test
library(olsrr) # for ols_test_breusch_pagan
library(strucchange) # for efp
library(CADFtest) # for CADFtest
library(aTSA) # for pp.test
library(ggpubr)# for ggarrange

table_list_wide <- list()


# data plots --------------------------------------------------------------

# pdf(paste0(fig_path, "/w_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = w)) +
    geom_line() +
    labs(x = "Time", y = 'w') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

# pdf(paste0(fig_path, "/prod_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = Prod)) +
    geom_line() +
    labs(x = "Time", y = 'Prod') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

# pdf(paste0(fig_path, "/ur_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = UR)) +
    geom_line() +
    labs(x = "Time", y = 'UR') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

# pdf(paste0(fig_path, "/wedge_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = Wedge)) +
    geom_line() +
    labs(x = "Time", y = 'Wedge') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

# pdf(paste0(fig_path, "/union_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = Union)) +
    geom_line() +
    labs(x = "Time", y = 'Union') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

# pdf(paste0(fig_path, "/unionr_wide.pdf"), width=5.6, height=4)
ggplot(data = data, aes(x = time(data), y = UnionR)) +
    geom_line() +
    labs(x = "Time", y = 'UnionR') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 4))
# dev.off()

data_plot <- data.frame(Time = rep(time(data), 2),
                        values = c(data[,"w"], data[,"Prod"]),
                        variable = c(rep("w", nrow(data)), rep("Prod", nrow(data))))

plot_w_prod_wide <- ggplot(data = data_plot, aes(x = Time, y = values, group = variable)) +
    geom_line(aes(linetype = variable)) +
    labs(y = 'Log Scale', linetype = "Variables") +
    theme(legend.position="bottom") +
    scale_x_continuous(breaks = seq(1971, 2019, by = 6))

data_plot <- data.frame(Time = rep(time(diff(data)), 2),
                        values = c(diff(data[,"w"]), diff(data[,"Prod"])),
                        variable = c(rep("Δw", nrow(diff(data))), rep("ΔProd", nrow(diff(data)))))

plot_w_prod_diff_wide <- ggplot(data = data_plot, aes(x = Time, y = values, group = variable)) +
    geom_line(aes(linetype = variable)) +
    labs(y = 'First Differences', linetype = "Variables") +
    geom_abline(aes(intercept = 0, slope = 0), linetype = 2) +
    theme(legend.position="bottom") +
    scale_x_continuous(breaks = seq(1971, 2019, by = 6))

data_plot <- data.frame(Time = rep(time(data), 2),
                        values = c(data[,"Wedge"], data[,"Union"]),
                        variable = c(rep("Wedge", nrow(data)), rep("Union", nrow(data))))

plot_wedge_union_wide <- ggplot(data = data_plot, aes(x = Time, y = values, group = variable)) +
    geom_line(aes(linetype = variable)) +
    labs(y = 'Log Scale', linetype = "Variables") +
    theme(legend.position="bottom") +
    scale_x_continuous(breaks = seq(1971, 2019, by = 6))

plot_ur_wide <- ggplot(data = data.frame(data), aes(x = time(data), y = UR)) +
    geom_line() +
    labs(x = "Time", y = 'UR') +
    scale_x_continuous(breaks = seq(1971, 2019, by = 6))

# cairo_pdf(paste0(fig_path, "/full_wide.pdf"), width=7, height=5.5)
# cairo_pdf(paste0(fig_path, "/Figure_2.pdf"), width=7, height=5.5)
plot_full_wide <- ggarrange(plot_w_prod_wide,
                            plot_w_prod_diff_wide,
                            plot_wedge_union_wide,
                            plot_ur_wide,
                            labels = c("(a)", "(b)", "(c)", "(d)"),
                            font.label = list(face = "plain", size = 11),
                            ncol = 2, nrow = 2)
plot_full_wide
# dev.off()


# data and formulas -------------------------------------------------------

# define the economic models
formula_n = w ~ Prod + UR + Wedge + Union -1 | D7475 + D7579
formula_c = w ~ Prod + UR + Wedge + Union | D7475 + D7579
formula_ct = w ~ Prod + UR + Wedge + Union + trend(w, scale = FALSE) | D7475 + D7579

# Define ARDL order -------------------------------------------------------

# calculate unrestricted ECMs from the underlying ARDL(p) models with p = 1, 2, ..., 7.
uecm_n_p <- lapply(1:7, function(p) uecm(ardl(formula_n, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))
uecm_c_p <- lapply(1:7, function(p) uecm(ardl(formula_c, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))
uecm_ct_p <- lapply(1:7, function(p) uecm(ardl(formula_ct, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))

Table_I_n <- Table_I(uecm_n_p, LM_orders = 1:5, latex_type = FALSE)
Table_I_c <- Table_I(uecm_c_p, LM_orders = 1:5, latex_type = FALSE)
Table_I_ct <- Table_I(uecm_ct_p, LM_orders = 1:5, latex_type = FALSE)
Table_I_n_ltx <- Table_I(uecm_n_p, LM_orders = 1:5, latex_type = TRUE)
Table_I_c_ltx <- Table_I(uecm_c_p, LM_orders = 1:5, latex_type = TRUE)
Table_I_ct_ltx <- Table_I(uecm_ct_p, LM_orders = 1:5, latex_type = TRUE)
Table_I_n
Table_I_c
Table_I_ct
colnames(Table_I_n_ltx) <- colnames(Table_I_c_ltx) <- colnames(Table_I_ct_ltx) <- c("p", "AIC", "SBC", paste0("$X^{2}_{SC}(", 1:5, ")$"))

tabI <- rbind(Table_I_n_ltx, Table_I_c_ltx, Table_I_ct_ltx)
table_list_wide$tabI <- tabI
tabI_no_n <- rbind(Table_I_c_ltx, Table_I_ct_ltx)
table_list_wide$tabI_no_n <- tabI_no_n

# check with restrictions on Prod and Union
uecm_n_p_restr <- lapply(1:7, function(p) uecm(ardl(formula_n, order = c(p, 1, p, p, 1), data = data, start = c(1972, 4))))
uecm_c_p_restr <- lapply(1:7, function(p) uecm(ardl(formula_c, order = c(p, 1, p, p, 1), data = data, start = c(1972, 4))))
uecm_ct_p_restr <- lapply(1:7, function(p) uecm(ardl(formula_ct, order = c(p, 1, p, p, 1), data = data, start = c(1972, 4))))
Table_I_n_restr <- Table_I(uecm_n_p_restr, LM_orders = 1:5, latex_type = FALSE)
Table_I_c_restr <- Table_I(uecm_c_p_restr, LM_orders = 1:5, latex_type = FALSE)
Table_I_ct_restr <- Table_I(uecm_ct_p_restr, LM_orders = 1:5, latex_type = FALSE)
Table_I_n_restr
Table_I_c_restr
Table_I_ct_restr

# auto ardl with constant
# almost 30 mins
#    w Prod UR Wedge Union  AIC_pss
# 1  4    1  0     5     0 590.9790
# 2  4    1  3     5     0 590.3261
# 3  2    1  0     5     0 590.1678
# 4  4    2  0     5     0 590.1261
# 5  4    1  0     5     1 590.0044
# models_top_auto_c <- auto_ardl(formula_c, data = data, start = c(1972, 4),
#     max_order = 7, grid = TRUE,
#     selection = "AIC_pss", selection_minmax = "max")
# models_top_auto_c$top_order

# fix the Prod=1 and Union=0
#models_top_auto_c <- auto_ardl(formula_c, data = data, start = c(1972, 4),
#                               max_order = 7, fixed_order = c(-1,1,-1,-1,0),
#                               selection = "AIC_pss", selection_minmax = "max")
#models_top_auto_c$top_orders # ARDL(4,1,3,5,0) 590.3261

# using starting orders
#models_top_auto_c <- auto_ardl(formula_c, data = data, start = c(1972, 4),
#                               max_order = 7, starting_order =  c(4,1,0,4,0),
#                               selection = "AIC_pss", selection_minmax = "max", search_type = "ver")
#models_top_auto_c$top_orders # ARDL(4,1,0,5,0) 590.9790

# auto ardl with constant and trend
# almost 30 mins
#    w Prod UR Wedge Union  AIC_pss
# 1  4    1  6     5     2 591.5789
# 2  4    1  3     5     2 591.5128
# 3  4    1  6     5     3 591.2745
# 4  4    1  5     5     2 591.2570
# 5  4    1  3     5     3 591.1757
# 6  4    1  3     5     0 591.1489
# 7  4    1  5     5     3 591.1101
# models_top_auto_ct <- auto_ardl(formula_ct, data = data, start = c(1972, 4),
#     max_order = 7, grid = TRUE,
#     selection = "AIC_pss", selection_minmax = "max")
# models_top_auto_ct$top_order

#models_top_auto_ct <- auto_ardl(formula_ct, data = data, start = c(1972, 4),
#                                max_order = 7, fixed_order = c(-1,1,-1,-1,-1),
#                                selection = "AIC_pss", selection_minmax = "max")
#models_top_auto_ct$top_orders # ARDL(4,1,6,5,2) 591.5789


# F and t bound tests -----------------------------------------------------

uecm_model_cases23 <- list(uecm(formula_c, data = data, start = c(1972, 4), order = c(4,1,0,5,0)),
                           uecm(formula_c, data = data, start = c(1972, 4), order = c(4,1,3,5,0)),
                           uecm(formula_c, data = data, start = c(1972, 4), order = c(4,1,6,5,2)),
                           uecm(formula_c, data = data, start = c(1972, 4), order = c(4,1,3,5,2)))
uecm_model_cases45 <- list(uecm(formula_ct, data = data, start = c(1972, 4), order = c(4,1,0,5,0)),
                           uecm(formula_ct, data = data, start = c(1972, 4), order = c(4,1,3,5,0)),
                           uecm(formula_ct, data = data, start = c(1972, 4), order = c(4,1,6,5,2)),
                           uecm(formula_ct, data = data, start = c(1972, 4), order = c(4,1,3,5,2)))

Table_II <- build_Table_II(uecm_model_cases23, uecm_model_cases45, cases = c(2,3,4,5), replication = "wide", latex_type = FALSE)
Table_II
Table_II_ltx <- build_Table_II(uecm_model_cases23, uecm_model_cases45, cases = c(2,3,4,5), replication = "wide", latex_type = TRUE)
Table_II[1:2,c(5:7)] <- Table_II_ltx[1:2,c(5:7)] <- "-"
Table_II[3:4,c(2:4)] <- Table_II_ltx[3:4,c(2:4)] <- "-"
tabII <- cbind(Table_II_ltx[1:4], "", Table_II_ltx[5:7])
colnames(tabII)[5] <- ""
table_list_wide$tabII <- tabII
Table_II

# only constant
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 0, 5, 0)
uecm_c_41050 <- uecm(formula_c, order = c(4, 1, 0, 5, 0), data = data, start = c(1972, 4))
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 3, 5, 0)
uecm_c_41350 <- uecm(formula_c, order = c(4, 1, 3, 5, 0), data = data, start = c(1972, 4))

# constant and trend
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 6, 5, 2)
uecm_ct_41652 <- uecm(formula_ct, order = c(4, 1, 6, 5, 2), data = data, start = c(1972, 4))
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 3, 5, 2)
uecm_ct_41352 <- uecm(formula_ct, order = c(4, 1, 3, 5, 2), data = data, start = c(1972, 4))

# Exact sample F & t bounds tests on the parsimonious models
# Each run can take from 20 seconds to 3 minutes. All together may take more than 10 minutes
# set.seed(2020)
# uecm_c_41050_f_c2 <- bounds_f_test(object = uecm_c_41050, case = 2, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41050_f_c3 <- bounds_f_test(object = uecm_c_41050, case = 3, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41050_t_c3 <- bounds_t_test(object = uecm_c_41050, case = 3, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41350_f_c2 <- bounds_f_test(object = uecm_c_41350, case = 2, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41350_f_c3 <- bounds_f_test(object = uecm_c_41350, case = 3, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41350_t_c3 <- bounds_t_test(object = uecm_c_41350, case = 3, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)

# set.seed(2020)
# uecm_c_41652_f_c4 <- bounds_f_test(object = uecm_ct_41652, case = 4, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41652_f_c5 <- bounds_f_test(object = uecm_ct_41652, case = 5, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41652_t_c5 <- bounds_t_test(object = uecm_ct_41652, case = 5, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41352_f_c4 <- bounds_f_test(object = uecm_ct_41352, case = 4, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41352_f_c5 <- bounds_f_test(object = uecm_ct_41352, case = 5, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)
# set.seed(2020)
# uecm_c_41352_t_c5 <- bounds_t_test(object = uecm_ct_41352, case = 5, alpha = 0.05, pvalue = TRUE, exact = TRUE, R = 70000)

# data preparation for the plot
uecm_c_coint_eq <- data.frame(w = rep(data[,'w'], 4),Time = rep(time(data),8),
                              data = c(data[,'w'], coint_eq(uecm_c_41050, case = 2),
                                       data[,'w'], coint_eq(uecm_c_41050, case = 3),
                                       data[,'w'], coint_eq(uecm_c_41350, case = 2),
                                       data[,'w'], coint_eq(uecm_c_41350, case = 3)),
                              Variables = c(rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data))),
                              case = c(rep("Case 2",nrow(data)*2),
                                       rep("Case 3",nrow(data)*2),
                                       rep("Case 2",nrow(data)*2),
                                       rep("Case 3",nrow(data)*2)),
                              ardl = c(rep("ARDL(4,1,0,5,0)",nrow(data)*4),
                                       rep("ARDL(4,1,3,5,0)",nrow(data)*4)))

uecm_ct_coint_eq <- data.frame(w = rep(data[,'w'], 4),Time = rep(time(data),8),
                               data = c(data[,'w'], coint_eq(uecm_ct_41652, case = 4),
                                        data[,'w'], coint_eq(uecm_ct_41652, case = 5),
                                        data[,'w'], coint_eq(uecm_ct_41352, case = 4),
                                        data[,'w'], coint_eq(uecm_ct_41352, case = 5)),
                               Variables = c(rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data))),
                               case = c(rep("Case 4",nrow(data)*2),
                                        rep("Case 5",nrow(data)*2),
                                        rep("Case 4",nrow(data)*2),
                                        rep("Case 5",nrow(data)*2)),
                               ardl = c(rep("ARDL(4,1,6,5,2)",nrow(data)*4),
                                        rep("ARDL(4,1,3,5,2)",nrow(data)*4)))

# pdf(paste0(fig_path, "/coint-eq-c.pdf"), width=5.6, height=4)
ggplot(data = uecm_c_coint_eq, aes(x = Time, y = data, group = Variables, linetype = Variables)) +
    geom_line() +
    facet_grid(case ~ ardl, scales = "free") +
    labs(y = 'Log Scale') +
    theme(legend.position="bottom")
# dev.off()

# pdf(paste0(fig_path, "/coint-eq-ct.pdf"), width=5.6, height=4)
ggplot(data = uecm_ct_coint_eq, aes(x = Time, y = data, group = Variables, linetype = Variables)) +
    geom_line() +
    facet_grid(case ~ ardl, scales = "free") +
    labs(y = 'Log Scale') +
    theme(legend.position="bottom")
# dev.off()

# Long-Run multipliers
lr_mult <- multipliers(uecm_c_41050)
tab_lvls_relat <- rbind(lr_mult[-1,], lr_mult[1,])[,c(1:3,5)]
colnames(tab_lvls_relat)[1] <- "variable"
table_list_wide$tab_lvls_relat <- tab_lvls_relat

# Table III
tabIII_uecm <- build_Table_III_wide(uecm_c_41050)
summary(uecm_c_41050)
table_list_wide$tabIII_uecm <- tabIII_uecm

# diagnostic tests under the UECM table -----------------------------------

table_list_wide$uecm_tests <- ecm_tests(uecm_c_41050)


# Long-Run multipliers tests ----------------------------------------------

# test if prod and wedge != 1
# The coefficients of the productivity and the wedge variables 
# are significantly different from unity
prod_t <- (1 - lr_mult[which(lr_mult == "Prod"), "estimate"]) / lr_mult[which(lr_mult == "Prod"), "std.error"]
wedge_t <- (1 - lr_mult[which(lr_mult == "Wedge"), "estimate"]) / lr_mult[which(lr_mult == "Wedge"), "std.error"]
# prod = 1 statistically
2 * pt(abs(prod_t), df = df.residual(uecm_c_41050), lower.tail = FALSE)
# wedge != 1 statistically
2 * pt(abs(wedge_t), df = df.residual(uecm_c_41050), lower.tail = FALSE)
# or using CIs
lr_mult[which(lr_mult == "Prod"), "estimate"] + c(-2*lr_mult[which(lr_mult == "Prod"), "std.error"], 2*lr_mult[which(lr_mult == "Prod"), "std.error"])
lr_mult[which(lr_mult == "Wedge"), "estimate"] + c(-2*lr_mult[which(lr_mult == "Wedge"), "std.error"], 2*lr_mult[which(lr_mult == "Wedge"), "std.error"])


# unit root tests ---------------------------------------------------------

table_list_wide$tab_unit_root_lvls <- unit_root_table(data, levels = TRUE)
table_list_wide$tab_unit_root_diff <- unit_root_table(data, levels = FALSE)


# structural change tests -------------------------------------------------
mm <- uecm_c_41050$model
colnames(mm) <- paste0("X", 1:ncol(mm))

cusum_test <- efp(formula(X1 ~ X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 + X10 + X11 +X12 + 
                              X13 + X14 + X15 + X16 + X17), 
                  data = mm, type = "OLS-CUSUM")
cusum_test_bounds <- boundary(cusum_test, alpha = 0.05)

cusumrec_test <- efp(formula(X1 ~ X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 + X10 + X11 +X12 + 
                                 X13 + X14 + X15 + X16 + X17), 
                     data = mm, type = "Rec-CUSUM")
cusumrec_test_bounds <- boundary(cusumrec_test, alpha = 0.05)

mosum_test <- efp(formula(X1 ~ X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 + X10 + X11 +X12 + 
                              X13 + X14 + X15 + X16 + X17), 
                  data = mm, type = "OLS-MOSUM")
mosum_test_bounds <- boundary(mosum_test, alpha = 0.05)

mosumrec_test <- efp(formula(X1 ~ X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 + X10 + X11 +X12 + 
                                 X13 + X14 + X15 + X16 + X17), 
                     data = mm, type = "Rec-MOSUM")
mosumrec_test_bounds <- boundary(mosumrec_test, alpha = 0.05)

str_ch_data <- ts.union(cusum_test$process, cusumrec_test$process, mosum_test$process, mosumrec_test$process,
                        cusum_test_bounds, cusumrec_test_bounds, mosum_test_bounds, mosumrec_test_bounds,
                        time(cusum_test$process), time(cusumrec_test$process), time(mosum_test$process), time(mosumrec_test$process))

str_ch_data <- data.frame(process = c(str_ch_data[,1], str_ch_data[,2], str_ch_data[,3], str_ch_data[,4]),
                          bounds = c(str_ch_data[,5], str_ch_data[,6], str_ch_data[,7], str_ch_data[,8]),
                          Time = c(str_ch_data[,9], str_ch_data[,10], str_ch_data[,11], str_ch_data[,12]),
                          type1 = c(rep("OLS-based",nrow(str_ch_data)),
                                    rep("Recursive",nrow(str_ch_data)),
                                    rep("OLS-based",nrow(str_ch_data)),
                                    rep("Recursive",nrow(str_ch_data))),
                          type2 = c(rep("CUSUM",nrow(str_ch_data)*2),
                                    rep("MOSUM",nrow(str_ch_data)*2)))

# pdf(paste0(fig_path, "/str_change.pdf"), width=5.6, height=4)
ggplot(data = str_ch_data, aes(x = Time, y = process)) +
    geom_line() +
    geom_line(aes(y = bounds)) +
    geom_line(aes(y = -bounds)) +
    geom_abline(intercept = 0, slope = 0, linetype = 2) +
    facet_grid(type1 ~ type2, scales = "free") +
    labs(y = 'Empirical fluctuation process')
# dev.off()

sctest(cusum_test)
sctest(cusumrec_test)
sctest(mosum_test)
sctest(mosumrec_test)


# Extended wide sense replication -----------------------------------------

# data and formulas -------------------------------------------------------

# define the economic models
#formula_nX = w ~ Prod + UR + Wedge + UnionR -1 | D7475 + D7579
#formula_cX = w ~ Prod + UR + Wedge + UnionR | D7475 + D7579
#formula_ctX = w ~ Prod + UR + Wedge + UnionR + trend(w, scale = FALSE) | D7475 + D7579
# or
formula_nX = w ~ Prod + UR + Wedge + UnionR -1 | D7475
formula_cX = w ~ Prod + UR + Wedge + UnionR | D7475
formula_ctX = w ~ Prod + UR + Wedge + UnionR + trend(w, scale = FALSE) | D7475

# Define ARDL order -------------------------------------------------------

# calculate unrestricted ECMs from the underlying ARDL(p) models with p = 1, 2, ..., 7.
uecm_n_pX <- lapply(1:7, function(p) uecm(ardl(formula_nX, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))
uecm_c_pX <- lapply(1:7, function(p) uecm(ardl(formula_cX, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))
uecm_ct_pX <- lapply(1:7, function(p) uecm(ardl(formula_ctX, order = c(p, p, p, p, p), data = data, start = c(1972, 4))))

Table_I_nX <- Table_I(uecm_n_pX, LM_orders = 1:5, latex_type = FALSE)
Table_I_cX <- Table_I(uecm_c_pX, LM_orders = 1:5, latex_type = FALSE)
Table_I_ctX <- Table_I(uecm_ct_pX, LM_orders = 1:5, latex_type = FALSE)
Table_I_nX_ltx <- Table_I(uecm_n_pX, LM_orders = 1:5, latex_type = TRUE)
Table_I_cX_ltx <- Table_I(uecm_c_pX, LM_orders = 1:5, latex_type = TRUE)
Table_I_ctX_ltx <- Table_I(uecm_ct_pX, LM_orders = 1:5, latex_type = TRUE)
Table_I_nX
Table_I_cX
Table_I_ctX
colnames(Table_I_nX_ltx) <- colnames(Table_I_cX_ltx) <- colnames(Table_I_ctX_ltx) <- c("p", "AIC", "SBC", paste0("$X^{2}_{SC}(", 1:5, ")$"))

tabIX <- rbind(Table_I_nX_ltx, Table_I_cX_ltx, Table_I_ctX_ltx)
#table_list_wide$tabIX <- tabIX
tabI_no_nX <- rbind(Table_I_cX_ltx, Table_I_ctX_ltx)
#table_list_wide$tabI_no_nX <- tabI_no_nX

# AIC_pss optimization
#library(parallel) # is uses forking and so it works only for Linux. Use another parallel method for windows or run everything on one core.

# auto ardl with constant
#auto_ardl_c_AIC_pss <- function(i) {
#    auto_ardl(formula_cX, data = data, start = c(1972, 4), 
#              fixed_order = c(i,-1,-1,-1,-1), max_order = 7, grid = TRUE,
#              selection = "AIC_pss", selection_minmax = "max")
#}
#models_c_full_grid_AIC_pss <- mclapply(1:7, auto_ardl_c_AIC_pss, mc.cores = 7)

#top_orders_c_full_grid_AIC_pss <- data.frame()
#for (i in 1:7) {
#    top_orders_c_full_grid_AIC_pss <- rbind(top_orders_c_full_grid_AIC_pss, models_c_full_grid_AIC_pss[[i]]$top_orders)
#}
#top_orders_c_full_grid_AIC_pss <- top_orders_c_full_grid_AIC_pss[order(top_orders_c_full_grid_AIC_pss$AIC_pss, decreasing = TRUE), ]
#rownames(top_orders_c_full_grid_AIC_pss) <- NULL
#top_orders_c_full_grid_AIC_pss[1:20,]
#   w Prod UR Wedge UnionR  AIC_pss
#1  4    1  0     5      5 594.6734
#2  4    1  0     5      3 594.3752
#3  4    1  0     5      6 594.3530
#4  4    1  0     5      4 594.1005
#5  4    1  1     5      5 593.9147
#6  4    1  0     6      5 593.7258
#7  4    2  0     5      5 593.7222
#8  5    1  0     5      5 593.6910
#9  4    1  1     5      6 593.5943
#10 4    1  3     5      3 593.5663
#11 4    1  1     5      3 593.5524
#12 4    1  0     6      3 593.4586
#13 5    1  0     5      6 593.4524
#14 4    1  0     6      6 593.4495
#15 4    2  0     5      6 593.4113
#16 5    1  0     5      3 593.3860
#17 4    2  0     5      3 593.3791
#18 4    1  0     5      7 593.3650
#19 2    1  0     5      4 593.3468
#20 4    1  1     5      4 593.3244

# auto ardl with constant and trend
#auto_ardl_ct_AIC_pss <- function(i) {
#    auto_ardl(formula_ctX, data = data, start = c(1972, 4), 
#              fixed_order = c(i,-1,-1,-1,-1), max_order = 7, grid = TRUE,
#              selection = "AIC_pss", selection_minmax = "max")
#}
#models_ct_full_grid_AIC_pss <- mclapply(1:7, auto_ardl_ct_AIC_pss, mc.cores = 7)

#top_orders_ct_full_grid_AIC_pss <- data.frame()
#for (i in 1:7) {
#    top_orders_ct_full_grid_AIC_pss <- rbind(top_orders_ct_full_grid_AIC_pss, models_ct_full_grid_AIC_pss[[i]]$top_orders)
#}
#top_orders_ct_full_grid_AIC_pss <- top_orders_ct_full_grid_AIC_pss[order(top_orders_ct_full_grid_AIC_pss$AIC_pss, decreasing = TRUE), ]
#rownames(top_orders_ct_full_grid_AIC_pss) <- NULL
#top_orders_ct_full_grid_AIC_pss[1:20,]
#   w Prod UR Wedge UnionR  AIC_pss
#1  4    1  0     5      5 594.3979
#2  4    1  0     5      6 593.9280
#3  4    1  0     5      3 593.6835
#4  4    2  0     5      5 593.5852
#5  4    1  0     5      4 593.5412
#6  4    1  1     5      5 593.4107
#7  5    1  0     5      5 593.4094
#8  4    1  0     6      5 593.3999
#9  4    1  3     5      3 593.1547
#10 4    2  0     5      6 593.1134
#11 4    1  3     5      5 593.0220
#12 5    1  0     5      6 593.0023
#13 4    1  0     5      7 592.9706
#14 4    1  1     5      6 592.9532
#15 4    1  0     6      6 592.9474
#16 2    1  0     5      5 592.7998
#17 2    1  0     5      4 592.7676
#18 4    1  1     5      3 592.7184
#19 4    2  0     5      3 592.7172
#20 4    1  0     6      3 592.7162

# F and t bound tests -----------------------------------------------------

uecm_model_cases23X <- list(uecm(formula_cX, data = data, start = c(1972, 4), order = c(4,1,0,5,5)),
                           uecm(formula_cX, data = data, start = c(1972, 4), order = c(4,1,0,5,3)),
                           uecm(formula_cX, data = data, start = c(1972, 4), order = c(4,1,0,5,5)),
                           uecm(formula_cX, data = data, start = c(1972, 4), order = c(4,1,0,5,3)))
uecm_model_cases45X <- list(uecm(formula_ctX, data = data, start = c(1972, 4), order = c(4,1,0,5,5)),
                           uecm(formula_ctX, data = data, start = c(1972, 4), order = c(4,1,0,5,3)),
                           uecm(formula_ctX, data = data, start = c(1972, 4), order = c(4,1,0,5,5)),
                           uecm(formula_ctX, data = data, start = c(1972, 4), order = c(4,1,0,5,3)))

Table_IIX <- build_Table_II(uecm_model_cases23X, uecm_model_cases45X, cases = c(2,3,4,5), replication = "wide", latex_type = FALSE)
Table_IIX
Table_IIX_ltx <- build_Table_II(uecm_model_cases23X, uecm_model_cases45X, cases = c(2,3,4,5), replication = "wide", latex_type = TRUE)
Table_IIX[1:2,c(5:7)] <- Table_IIX_ltx[1:2,c(5:7)] <- "-"
Table_IIX[3:4,c(2:4)] <- Table_IIX_ltx[3:4,c(2:4)] <- "-"
tabIIX <- cbind(Table_IIX_ltx[1:4], "", Table_IIX_ltx[5:7])
colnames(tabIIX)[5] <- ""
#table_list_wide$tabIIX <- tabIIX
Table_IIX

# only constant
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 0, 5, 5)
uecm_c_41055X <- uecm(formula_cX, order = c(4, 1, 0, 5, 5), data = data, start = c(1972, 4))
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 0, 5, 3)
uecm_c_41053X <- uecm(formula_cX, order = c(4, 1, 0, 5, 3), data = data, start = c(1972, 4))

# constant and trend
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 0, 5, 5)
uecm_ct_41055X <- uecm(formula_ctX, order = c(4, 1, 0, 5, 5), data = data, start = c(1972, 4))
# parsimonious unrestricted conditional ECM based on the ARDL(4, 1, 0, 5, 3)
uecm_ct_41053X <- uecm(formula_ctX, order = c(4, 1, 0, 5, 3), data = data, start = c(1972, 4))

# data preparation for the plot
uecm_c_coint_eqX <- data.frame(w = rep(data[,'w'], 4),Time = rep(time(data),8),
                              data = c(data[,'w'], coint_eq(uecm_c_41055X, case = 2),
                                       data[,'w'], coint_eq(uecm_c_41055X, case = 3),
                                       data[,'w'], coint_eq(uecm_c_41053X, case = 2),
                                       data[,'w'], coint_eq(uecm_c_41053X, case = 3)),
                              Variables = c(rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data)),
                                            rep("w", nrow(data)),
                                            rep("Long-Run Relationship", nrow(data))),
                              case = c(rep("Case 2",nrow(data)*2),
                                       rep("Case 3",nrow(data)*2),
                                       rep("Case 2",nrow(data)*2),
                                       rep("Case 3",nrow(data)*2)),
                              ardl = c(rep("ARDL(4,1,0,5,5)",nrow(data)*4),
                                       rep("ARDL(4,1,0,5,3)",nrow(data)*4)))

uecm_ct_coint_eqX <- data.frame(w = rep(data[,'w'], 4),Time = rep(time(data),8),
                               data = c(data[,'w'], coint_eq(uecm_ct_41055X, case = 4),
                                        data[,'w'], coint_eq(uecm_ct_41055X, case = 5),
                                        data[,'w'], coint_eq(uecm_ct_41053X, case = 4),
                                        data[,'w'], coint_eq(uecm_ct_41053X, case = 5)),
                               Variables = c(rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data)),
                                             rep("w", nrow(data)),
                                             rep("Long-Run Relationship", nrow(data))),
                               case = c(rep("Case 4",nrow(data)*2),
                                        rep("Case 5",nrow(data)*2),
                                        rep("Case 4",nrow(data)*2),
                                        rep("Case 5",nrow(data)*2)),
                               ardl = c(rep("ARDL(4,1,0,5,5)",nrow(data)*4),
                                        rep("ARDL(4,1,0,5,3)",nrow(data)*4)))

ggplot(data = uecm_c_coint_eqX, aes(x = Time, y = data, group = Variables, linetype = Variables)) +
    geom_line() +
    facet_grid(case ~ ardl, scales = "free") +
    labs(y = 'Log Scale') +
    theme(legend.position="bottom")

ggplot(data = uecm_ct_coint_eqX, aes(x = Time, y = data, group = Variables, linetype = Variables)) +
    geom_line() +
    facet_grid(case ~ ardl, scales = "free") +
    labs(y = 'Log Scale') +
    theme(legend.position="bottom")

# Long-Run multipliers
lr_multX <- multipliers(uecm_c_41055X)
tab_lvls_relatX <- rbind(lr_multX[-1,], lr_multX[1,])[,c(1:3,5)]
colnames(tab_lvls_relatX)[1] <- "variable"
table_list_wide$tab_lvls_relatX <- tab_lvls_relatX
