"""
Master script for Making Text Count.

This script assumes you have one newspaper per csv stored in data/raw, eg
GRDN.csv. It then calls all the scripts to make the paper.

"""

# Produce algorithmic text metrics from single CSVs per newspaper (picked up from data/raw/, stored in data/intermed
import src.textmetricproduce

# Produce term-frequency matrices (used for ML forecasts), picked up from data/raw, stored in data/intermed
import src.tfmatrixproduce as tfmat
tfmat.tf_matrices_of_newspaper_full_text()

# Create data looking at stats of algorithmic text metrics (autocorrs, ADF tests, swathe data for swathe chart)
import src.proxy

# Run all of the algorithmic forecasts
import src.algfcast as algfcast
algfcast.run_all_AR1_text_metric_fcasts()
algfcast.run_all_factor_model_text_metric_fcasts()

# Run all of the ML forecasts.
# WARNING: this will take an *extremely* long time on a single machine. There is code in the
# repo to run this as a batch job on cloud (see mlbatchrun.py and the section of mlfcast.py on 'Batch job code for running on cloud')
import src.mlfcast as mlfcast
mlfcast.run_all_ML_model_fcasts()
mlfcast.create_summary_ML_files()

# Based on the results from previous sections, this now creates all the charts and tables except those from the paper revisions
import src.figsandtables as figsandtables
figsandtables.produce_all_charts_and_tables()

# Charts for paper revisions are in partial_dependence.py and white_reality_test.py