/*
AUTHOR:   Todd Clark, Federal Reserve Bank of Cleveland, todd.clark@researchfed.org
Code associated with Andrea Carriero, Todd Clark and Massimiliano Marcellino, 
"Nowcasting Tail Risks to Economic Activity at a Weekly Frequency"

Program for reading in forecasts to construct charts for paper's Figure 2 and corresponding PQR charts in the appendix
Note re dating and samples:  Forecasts are dated by the forecast outcome date (current quarter, given nowcast setup)
*/

env nowshowgraphs
gsave(format=pdf) "fcchartsOOS_*.pdf"    ;* root of file name to which charts are written, in pdf format

comp styr = 1947
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data

comp stvint = 1985:1       ;* stvint is first vintage, which corresponds to the start of forecasting
comp endvint = 2021:1      ;* last quarter of data vintages considered
comp useactual = 1          ;* adjustment for obs lost of last vintage relative to eval sample end date (used to set this at 2)
comp endsmpl = endvint-useactual

comp stpt = 1985:1   ;* starting point for model estimation
comp dropcovid = 1  ;* 0 to chart forecasts through last avail obs in 2020, 1 to stop eval in 2019:Q4

all endvint
smpl stsmpl endvint

******************** actual GDP used as actuals
** read in GDP estimates used as actuals in evaluation of forecasts:  these are 2nd avail in the quarterly RTDSM
open data ../data/GDPactuals.secondrelease.xls
data(format=xls,org=col) / actualGDP
close
set gdp = actualGDP

**** NBER dates, quarterly
clear(length=endvint,zeroes) cycle
set cycle 1948:4 1949:4 = 1.0
set cycle 1953:2 1954:2 = 1.0
set cycle 1957:3 1958:2 = 1.0
set cycle 1960:2 1961:1 = 1.0
set cycle 1969:4 1970:4 = 1.0
set cycle 1973:4 1975:1 = 1.0
set cycle 1980:1 1980:3 = 1.0
set cycle 1981:3 1982:4 = 1.0
set cycle 1990:3 1991:1 = 1.0
set cycle 2001:1 2001:4 = 1.0
set cycle 2007:4 2009:2 = 1.0
set cycle 2019:4 2020:2 = 1.0

******************** dimensioning for reading in results
comp [vec[str]] methlabel = ||$
"base M-F:  BMF-SV",$
"base M-F:  BQR",$
"base M-F:  PQR",$
"base M-F + small weekly:  BMF-SV",$
"base M-F + small weekly:  BQR",$
"base M-F + small weekly:  PQR",$
"base M-F + large weekly:  BMF-SV",$
"base M-F + large weekly:  BQR",$
"base M-F + large weekly:  PQR"||

comp [vec[str]] filestouse = ||$
"out.forecastruns/basemacro_basefinance_SV",$
"out.fcprocessingfromdraws/fcresults_BQR_MF_empiricalpctiles",$
"out.fcprocessingfromdraws/fcresults_PQR_MF_empiricalpctiles",$
"out.forecastruns/basemacro_basefinance_smallwkly_SV",$
"out.fcprocessingfromdraws/fcresults_BQR_MF_smallwkly_empiricalpctiles",$
"out.fcprocessingfromdraws/fcresults_PQR_MF_smallwkly_empiricalpctiles",$
"out.forecastruns/basemacro_basefinance_largewkly_SV",$
"out.fcprocessingfromdraws/fcresults_BQR_MF_largewkly_empiricalpctiles",$
"out.fcprocessingfromdraws/fcresults_PQR_MF_largewkly_empiricalpctiles"||

comp nmeth = %rows(filestouse)
comp ntochart = nmeth-6   ;* leave small weekly and large weekly specs out of time series charts

******************** setting up storage
comp totweek = 15

*** what we use to read in, method by method
dec vec[ser] fcseries(totweek) pct10series(totweek) pct90series(totweek) 
do mm = 1,totweek 
 labels fcseries(mm)
 # 'fcseries_m'+%string(mm)
 labels pct10series(mm)
 # 'pct10_m'+%string(mm)
 labels pct90series(mm)
 # 'pct90_m'+%string(mm)
end do mm
clear fcseries pct10series pct90series 

*** what we use to store, covering all methods
dec rec[ser] pointfc(nmeth,totweek) q10fc(nmeth,totweek) q90fc(nmeth,totweek) 

******************** 
do nn = 1,%rows(filestouse)
 comp [str] filename = filestouse(nn)+".xls"
 dis filename
 open data &filename
 data(org=col,for=xls) / fcseries pct10series pct90series
 close data
 do mm = 1,totweek
  set pointfc(nn,mm) = fcseries(mm){0}
  set q10fc(nn,mm) = pct10series(mm){0} 
  set q90fc(nn,mm) = pct90series(mm){0} 
 end do mm
end do nn

**** form avg fcs for base M-F case by brute force
dec vec[ser] avgpointfc(totweek) avgquantfc(totweek)
clear(zeros) avgpointfc avgquantfc
do mm = 1,totweek
 set avgpointfc(mm) = (pointfc(1,mm){0}+pointfc(2,mm){0}+pointfc(3,mm){0})/3.
 set avgquantfc(mm) = (q10fc(1,mm){0}+q10fc(2,mm){0}+q10fc(3,mm){0})/3.
end do mm

**** set sample
if dropcovid==1
 comp endsmpl = %imin(2019:4,endsmpl)  ;* shortening sample to drop pandemic period
endif

** figure out common start point of sample
dec rec[int] smpldates(ntochart,2)
do i = 1,ntochart
 inquire(series=pointfc(i,1)) smpldates(i,1) smpldates(i,2)
 dis methlabel(i) @35 %datelabel(smpldates(i,1)) %datelabel(smpldates(i,2))
 if dropcovid==1
  comp smpldates(i,2) = endsmpl
end do i

******************** charts of each forecast by week (just odd weeks)
comp [vec[string]] mykey = ||'actual','point forecast','10th-%ile','90th-%ile'||

smpl stpt endsmpl

do nn = 1,ntochart
 smpl smpldates(nn,1) smpldates(nn,2)
 dofor mm = 3 7 11 15
  if mm==1
   comp forcemax=15., forcemin=-15.
  else
   comp forcemax=10., forcemin=-10.
  if mm==1
   comp header = methlabel(nn) + ", " + %string(mm) + " week of data"
  else
   comp header = methlabel(nn) + ", " + %string(mm) + " weeks of data"
  graph(header=header,dates,key=below,klab=mykey,shading=cycle,max=forcemax,min=forcemin) 4
  # GDP / 1
  # pointfc(nn,mm) / 2
  # q10fc(nn,mm) / 4
  # q90fc(nn,mm) / 4
 end do mm
end do nn
