********************************
/*SAMPLE SELECTION AND PARENTS*/
********************************

/* MP replication 

* Generate base sample:

born 1948, 1953 and in Sweden (non immigrant* don't have country of birth yet)
Plus parent identifier/residence/SEI/yrke (1960)
Plus place of birth 	(* don't have this data yet)
Plus place of residence 1960, 1965

*/

global datasave "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata\MPReplication"
global dataraw "\\micro.intra\Projekt\P0992$\P0992_Gem\rawdata\"
global mydata "\\micro.intra\Projekt\P0992$\P0992_Gem\mydata"


odbc load, exec("select * from dbo.Population_PersonNr")dsn("P0992") clear
gen byear=substr( FodelseArMan,1,4)
destring byear, replace
keep if byear<1948
save "$datasave\parents.dta", replace


odbc load, exec("select * from dbo.Population_PersonNr")dsn("P0992") clear
gen byear=substr( FodelseArMan,1,4)
destring byear, replace
keep if byear==1948 | byear==1953

gen bmonth=substr( FodelseArMan,5,2)
destring bmonth, replace
sum FelPersonNr /*drop 2 obs that have a dodgy personnummer, not clear their date of birth is correct as month is 23 or 29 which makes no sense */
drop if FelPersonNr==1 
drop AterAnv FodelseArMan FelPersonNr

* Gender (is male 1 or 2? always get this confused)
duplicates tag, gen(ind_dup)
browse if ind_dup!=0
tab ind_dup

bysort P0992_LopNr_PersonNr: gen counter=_n
bysort P0992_LopNr_PersonNr: gen counter2=_N
browse if counter2>1
 
drop if counter>1 /* 37 duplicate ids dropped */
drop counter

save "$datasave\BaseRepl.dta", replace

/*********** Merge UGU data ******************/



odbc load, exec("select * from dbo.vy_P0992_UGU48")dsn("P0992") clear
gen UGUYEAR=1948
bysort P0992_Lopnr_PersonNr: gen counter2=_N
browse if counter2>1
* Duplicate lopnr and not info is different in each row within duplicates, so drop these 6 observations
keep if counter2==1
drop counter2
tempfile UGU
save `UGU', replace

odbc load, exec("select * from dbo.vy_P0992_UGU53")dsn("P0992") clear
sum RSMYEAR

tempfile UGU2
save `UGU2', replace
sum RSMYEAR
mmerge  P0992_Lopnr_PersonNr   using `UGU', type(1:1) umatch(P0992_Lopnr_PersonNr )
tempfile UGU3
save `UGU3', replace

use "$datasave\BaseRepl.dta", clear
tempfile BASE
save `BASE', replace


mmerge  P0992_LopNr_PersonNr   using `UGU3', type(1:1) umatch(P0992_Lopnr_PersonNr )
drop _merge
sum RSMYEAR


save "$datasave\BaseRepl.dta", replace

****************************
/*Match Place of Birth Data */
****************************

odbc load, exec("select * from dbo.Fodelseuppg")dsn("P0992") clear
drop if VarldsdelNamn==""

bysort P0992_LopNr_PersonNr: gen counter=_n
drop if counter>1 /* 37 duplicate ids dropped */
drop counter

tempfile birthID
save `birthID'
*save "$datasave\birthdata.dta", replace
*clear
*cd "$datasave"
*unicode analyze birthdata.dta
*unicode encoding set ISO-8859-1
*unicode translate birthdata.dta
*use "$datasave\birthdata.dta", clear

*save "$dataraw\parentID.dta", replace

use "$datasave\BaseRepl.dta", clear
merge 1:1  P0992_LopNr_PersonNr  using "$datasave\birthdata.dta",    
drop if _merge==2
drop _merge

save "$datasave\BaseRepl.dta", replace

 
clear
cd "$datasave"
unicode analyze BaseRepl.dta
unicode encoding set ISO-8859-1
unicode translate BaseRepl.dta

use "$datasave\BaseRepl.dta", clear
merge m:1 byear FodelseForsNamn FodelseLan using "$mydata\pbcomb_kommun4853.dta"
drop if _merge==2
drop _m*

rename kommun60 fkommun60
rename kommun53 fkommun53


save "$datasave\BaseRepl.dta", replace

 

****************************
/*Match Parents ID */
****************************

odbc load, exec("select * from dbo.tn_foraldrar")dsn("P0992") clear
tempfile parentID
save `parentID'

use "$datasave\BaseRepl.dta", clear
mmerge  P0992_LopNr_PersonNr  using `parentID', type(1:1) umatch(P0992_Lopnr_PersonNr)
drop if _merge==2
drop _merge
save "$datasave\BaseRepl.dta", replace

 

******************
/*Sample Parents*/
******************

/* 
	1.) Sample their residence and gender of the 1960 Census

	 

odbc load, exec("select * from dbo.tn_fob_1960")dsn("P0992") clear
tempfile FOB60
save `FOB60'

use "$datasave\BaseRepl.dta", clear
mmerge  P0992_Lopnr_PersonNrMor  using `FOB60', type(n:1) umatch(P0992_LopNr_PersonNr) uname(MOR_)
drop if _merge==2
drop _m

mmerge  P0992_Lopnr_PersonNrFar  using `FOB60', type(n:1) umatch(P0992_LopNr_PersonNr) uname(FAR_)
drop if _merge==2
drop _m


gen parsame=(FAR_Kommun==MOR_Kommun)
gen parloc=0 if FAR_Kommun=="" & MOR_Kommun=="" 						/*No info on parents location in 1960*/
replace parloc=1 if MOR_Kommun!="" & FAR_Kommun=="" 					/*Only Mothers in FoB1960*/
replace parloc=2 if MOR_Kommun=="" & FAR_Kommun!=""						/*Only Fathers in FoB1960*/ 	
replace parloc=3 if FAR_Kommun!="" & MOR_Kommun!="" & parsame==0		/*Both are included but different place or residence*/
replace parloc=4 if FAR_Kommun!="" & MOR_Kommun!="" & parsame==1		/*Both are included and same place of residence*/


#delimit ;
label define parloc
 		0 "No Info on parents"
		1 "Only Mothers in FoB1960"
		2 "Only Fathers in FoB1960"
		3 "Both in FoB1960, but different place"
		4 "Both in FoB1960, same place"
;
#delimit cr
lab val parloc parloc
lab var parloc "Information Municipality of Residence Parents FoB60"

tab parloc 

*/

 
/*Get own place of residence in 1960*/

save "$datasave\BaseRepl.dta", replace

odbc load, exec("select * from dbo.tn_fob_1960")dsn("P0992") clear
tempfile FOB60
save `FOB60'

use "$datasave\BaseRepl.dta", clear
mmerge  P0992_LopNr_PersonNr  using `FOB60', type(1:1) umatch(P0992_LopNr_PersonNr) ukeep(Kommun Forsamling)
drop if _merge==2
drop _m
rename Forsamling parish_60
rename Kommun muni_60
save "$datasave\BaseRepl.dta", replace

odbc load, exec("select * from dbo.tn_fob_1965")dsn("P0992") clear
tempfile FOB65
save `FOB65'

use "$datasave\BaseRepl.dta", clear
mmerge  P0992_LopNr_PersonNr  using `FOB65', type(1:1) umatch(P0992_LopNr_PersonNr) ukeep(Kommun Forsamling)
drop if _merge==2
drop _m
rename Forsamling parish_65
rename Kommun muni_65
save "$datasave\BaseRepl.dta", replace


odbc load, exec("select * from dbo.tn_fob_1970")dsn("P0992") clear
tempfile EDU
save `EDU'
 
use "$datasave\BaseRepl.dta", clear

mmerge  P0992_Lopnr_PersonNrFar  using `EDU', type(n:1) umatch(P0992_LopNr_PersonNr) ukeep(SkolUtbAlm)  uname(FAR_)
drop if _merge==2
drop _m

 destring FAR_SkolUtbAlm, generate(edu_70f)
drop FAR_SkolUtbAlm
cap drop hife
gen hife=(inrange(edu_70f,41,89)) if edu_70f<.
 
 
mmerge  P0992_Lopnr_PersonNrMor  using `EDU', type(n:1) umatch(P0992_LopNr_PersonNr) ukeep(SkolUtbAlm)  uname(MOR_)
drop if _merge==2
drop _m

 destring MOR_SkolUtbAlm, generate(edu_70m)
drop MOR_SkolUtbAlm
cap drop hife_mother
gen hife_mother=(inrange(edu_70m,41,89)) if edu_70m<.
 
 save "$datasave\BaseRepl.dta", replace

 
 use "$datasave\parents.dta", clear
tempfile FARB
save `FARB', replace 
 
use "$datasave\BaseRepl.dta", clear
 
 
mmerge  P0992_Lopnr_PersonNrFar  using `FARB', type(n:1) umatch(P0992_LopNr_PersonNr)  uname(FAR_)
drop if _merge==2
drop _m

 
 
save "$datasave\BaseRepl.dta", replace

 odbc load, exec("select * from dbo.tn_fob_1960")dsn("P0992") clear
tempfile FOB60
save `FOB60'

use "$datasave\BaseRepl.dta", clear

mmerge  P0992_Lopnr_PersonNrFar  using `FOB60', type(n:1) umatch(P0992_LopNr_PersonNr) ukeep(SEI Yrke)  uname(FAR60_) 
drop if _merge==2
drop _m

cap drop hisesf
destring FAR60_SEI, force replace
gen hisesf=( inrange(FAR60_SEI,3,6)  )  
replace hisesf=. if FAR60_SEI==.
lab var hisesf "High SES Father"

save "$datasave\BaseRepl.dta", replace
