********************************
/*SAMPLE SELECTION AND PARENTS*/
********************************
set more off
capture log close


*global logsamp  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\log\samp"
*log using $logsamp\log_samppar.log, replace		


/* STEPS:
			1.) Extract Cohorts of Relevance for the Analyses
					First Cohort:	Start cohort 1932		(first cohort with linkage in intergenerational register)
					Last Cohort:	Last Cohort 1954		(last cohort with schooling in Census 1970 and Education Variables)
*/

****************************
/*MERGE BASIC VARIABLES*/
****************************
global mydata  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\mydata"

**Draw Baseline Population

set more off
global datasave  "\\micro.intra\projekt\P0524$\P0524_Gem\TN_MK_MF_School_reform_health_SES\mydata\NewSIPBaseData"		/*Save own Data*/
use  $datasave\ReformsNewSIP.dta  if inrange(cohort,1932,1954) ,   clear
 


merge 1:1 id using $datasave\EducNewSIP.dta
keep if _merge==3
drop _merge

merge 1:1 id using $datasave\ParentBNewSIP.dta
keep if _merge==3
drop _merge

*merge  m:1 sun2000niva90 using $mydata\imputeschool.dta
*drop _m
*rename cohort byear

cap drop _m
merge  1:1 id using "$anadata\educ1990.dta" , keepusing(sun2000niva_old sun2000niva)
drop if _m==2

rename sun2000niva_old sun2000niva_old90
rename sun2000niva sun2000niva90


cap drop yrseduc_MP2
gen yrseduc_MP2=.
replace yrseduc_MP2=7.33 if sun2000niva_old90=="1"
replace yrseduc_MP2=9.62 if sun2000niva_old90=="2"
replace yrseduc_MP2=10.39 if sun2000niva_old90=="3"
replace yrseduc_MP2=12.19 if sun2000niva_old90=="4"
replace yrseduc_MP2=13.87 if  sun2000niva_old90=="5"
replace yrseduc_MP2=16.77 if sun2000niva_old90=="6"
replace yrseduc_MP2=19.57 if sun2000niva_old90=="7"

destring sun2000niva90, replace

/*New Education based on 1990 Education Register*/
gen postschooling90=0 if sun2000niva90<400
replace postschooling90=1 if 	sun2000niva90==317 | sun2000niva90==313 | sun2000niva90==310	/* One Year Vocational Training*/
replace postschooling90=2 if 	sun2000niva90==327 | sun2000niva90==323 | sun2000niva90==320	/* Two Year Vocational Training*/
replace postschooling90=3 if 	sun2000niva90==337 | sun2000niva90==333 | sun2000niva90==330	/* Two Year Vocational Training*/

replace postschooling90=1 if 	sun2000niva90>400 & sun2000niva90<430							/* One Year Post Secondary Education*/
replace postschooling90=2 if 	sun2000niva90>=520 & sun2000niva90<530										/* Two Years Post Secondary Education*/
replace postschooling90=3 if 	sun2000niva90>=530 & sun2000niva90<540											/* Three Years Post Secondary Education*/
replace postschooling90=4 if 	sun2000niva90>=540 & sun2000niva90<550											/* Four Years Post Secondary Education*/
replace postschooling90=5 if 	sun2000niva90>=550 & sun2000niva90<560											/* Five Years Post Secondary Education*/
replace postschooling90=7 if 	sun2000niva90>=600 & sun2000niva90<640						/* Lic. university education */
replace postschooling90=9 if 	sun2000niva90==640										/* PhD university education */

cap drop  yearseduc_FOB90
gen yearseduc_FOB90=yrseducFOB
replace yearseduc_FOB90=yrseducFOB+postschooling90 if postschooling90!=.
lab var yearseduc_FOB90 "Years of education (UREG 1990)"

 
 preserve 
	keep  yrseducFOB yrseducMP cohort muniid corigin
	keep if muniid<. | corigin==29					/*Keep only if born in Sweden or in Census 60/65*/		
	gen comp1=(yrseducFOB<9) if yrseducFOB<.
	gen comp2=(yrseducMP<9) if yrseducMP<.
	collapse comp1 comp2, by(cohort)
	save $anadata\figure_miscomplier.dta, replace
 restore 
 
   
  
cap drop dif9_full
gen dif9_full=cohort-firstcohort60+100
tab dif9_full treat9

/*Sample Restrictions*/ 
  
keep if   inrange(cohort,1938,1954)			/*Keep only reform cohorts*/  
keep if   muniid<.							/*Keep if in Census 60/65*/  

/*Keep if non-missing education and essential covariates*/

keep if yearseduc_FOB<.
keep if yrseduc_MP<.
keep if male<.
keep if cohort<.
keep if yrseduc_MP2<.
keep if yearseduc_FOB90<.

**Baseline Sample
  gen  sex=male

	lab var hife "Fathers Education more than compulsory"
	lab var sex "Male"
	lab var muniid "Preferred municipality assignment"
	lab var postschooling "Post-Secondary / Tertiary Education"
	
save $anadata\anaMP_NS.dta, replace

 
/*Labor Earnings Samples*/

use $datasave\earn6816.dta, clear
keep if year>1984 & year<1997
tempfile earn
save `earn'

global educationvars "yrseduc_MP yearseduc_FOB postschooling"

use id cohort sex  yrseducFOB $educationvars treat9 treat9b treat9d    muniid   dif9_full fkommun60  firstcohort60   corigin /// 
		    hife hisesf FAR_yrseducFOB   using $anadata\anaMP_NS.dta, clear

 	


/*
**Rename 1990s variable to standard name

rename yrseduc_MP2 yrseduc_MP
rename yearseduc_FOB90 yearseduc_FOB
rename postschooling postschooling
*/

 merge 1:m id using `earn', keepusing(cpi year ARBINK CSFVI INRO INTJ)
 
drop if _m==2
drop _m

 /* 
 * GH change
sum cpi if year==2011
sca cpi2011=r(mean)
replace cpi=cpi/cpi2011
replace inc_labor=inc_labor*100
*/
  gen age=year-cohort
 
 

 
 cap drop lnearn_MP_INTJ
 gen lnearn_MP_INTJ=ln(INTJ) if INRO==0 
 

  lab var lnearn_MP_INTJ "Log Labor Earnings"

 save $anadata\ana_earn_fullMP_NS.dta, replace

 /*Replication Sample: Meghir & Palme (2005)*/

**Cohort: 1948, 1953
**Earnings: 1985-1996

use    if (cohort==1948 & year>1984 & year<1997) | (cohort==1953 & year>1984 & year<1997) using $anadata\ana_earn_fullMP_NS.dta, clear
 
gen less9=( yrseduc_MP<9) if  yrseduc_MP<.
gen  exact9=(yrseduc_MP>=9 & yrseduc_MP<10) if yrseduc_MP<.
gen more9=(yrseduc_MP>10) if yrseduc_MP<.
 
 lab var hife "Fathers Education more than compulsory"
 lab var yrseduc_MP "Years of Education (Palme)"
 lab var yearseduc_FOB "Years of Education"

 lab var less9 "Less than 9 Years of Schooling"
 lab var exact9 "9 Years of Schooling"
 lab var more9 "More than 9 Years of Schooling"
 
 lab var lnearn_MP_INTJ "Log Labor Earnings"
 
    gen treat9bFE=muniid
	gen treat9dFE= fkommun60
  
 
 sort id year
 save $anadata\palme_NS.dta, replace
  


/*Aggregated Sample: Meghir & Palme (2005)*/

**Cohort: 1948, 1953
**Earnings: Mean log earnings Age 30-35
 
 
 use $anadata\ana_earn_fullMP_NS.dta, clear
 
 keep if inrange(age,30,35)
 
gen lnearn_defl=lnearn_MP_INTJ-ln(cpi)
  
 #delimit ;
collapse (mean)   loginc3035b=lnearn_defl   yrseduc_MP firstcohort60 cohort sex   yrseducFOB postschooling    treat9b hife dif9_full muniid yearseduc_FOB, by(id) ;
#delimit cr

rename loginc3035b lnearn

 lab var lnearn "Log Labor Earnings"
 lab var hife "Fathers Education more than compulsory"
 lab var yearseduc_FOB "Years of Education"
 lab var treat9 "Treatment Comprehensive (with corrections)"
 lab var treat9b "Treatment Comprehensive (without corrections)"
 
save $anadata\ana_earn.dta, replace
 
 





