**Reduced Form Earnings
 
global y  "lnearn_MP_INTJ"

/*REDUCED FORM RESULTS, Sample Cohorts Meghir & Palme (2005)*/
*global treat "treat9b "

/* Sources:

		SIP - full population
		UGU - Gothenburg original data
		AER - MP (2005) original sample

*/


 
 cd "$results"
	dir

	clear
	gen outcome=""
 
global treat "treat9b  treat9d"
 local sample="SIP"
 
/*Both*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all.dta
replace outcome="`var'" if outcome==""
}

}
drop if parm=="_cons"
gen ses=1
gen type="pooled"
 
	
/*Low SES*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all_lfe.dta			/*Low Father Education 1970 Census*/
replace outcome="`var'" if outcome==""
replace ses=2 if ses==.
replace type="EDU70" if type==""

append using `sample'_`var'_`i'_all_lfs.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=2 if ses==.
replace type="OCC60" if type==""

		}

	}

	
	
/*High SES*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all_hfe.dta			/*Low Father Education 1970 Census*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="EDU70" if type==""

append using `sample'_`var'_`i'_all_hfs.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="OCC60" if type==""

		}

	}
	
	
gen sample="SIP"

/*Result from UGU Sample*/

global treat "treat9b treat9c treat9d reformMP2"
 local sample="UGU"
 
	
/*Both*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all.dta
replace outcome="`var'" if outcome==""
replace ses=1 if ses==.
replace type="pooled" if type==""

}

}

*sort parm outcome
*gen estno=_n
 
 
	
/*Low SES*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all_lfe.dta			/*Low Father Education 1970 Census*/
replace outcome="`var'" if outcome==""
replace ses=2 if ses==.
replace type="EDU70" if type==""

append using `sample'_`var'_`i'_all_lfeMP.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""a
replace ses=2 if ses==.
replace type="EDUSURV" if type==""

append using `sample'_`var'_`i'_all_lfs.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=2 if ses==.
replace type="OCC60" if type==""

		}

	}

	
	
/*High SES*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all_hfe.dta			/*Low Father Education 1970 Census*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="EDU70" if type==""

append using `sample'_`var'_`i'_all_hfeMP.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="EDUSURV" if type==""

append using `sample'_`var'_`i'_all_hfs.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="OCC60" if type==""

		}

	}

	
replace sample="SAMPLE_UGU" if sample==""
	
/*Result from AER Sample*/

global treat "treat9 treat9c"
 local sample="AER"
 
	
/*Both*/
foreach i of global treat {
foreach var of global  y {

append using `sample'_`var'_`i'_all.dta
replace outcome="`var'" if outcome==""
replace ses=1 if ses==.
replace type="pooled" if type==""

}

}


	
/*Low SES*/
foreach i of global treat {
foreach var of global  y {
 
append using `sample'_`var'_`i'_all_lfeMP.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=2 if ses==.
replace type="EDUSURV" if type==""

		}

	}

	
	
/*High SES*/
foreach i of global treat {
foreach var of global  y {
 

append using `sample'_`var'_`i'_all_hfeMP.dta			/*Low Father Socio-Economic Statust 1960*/
replace outcome="`var'" if outcome==""
replace ses=3 if ses==.
replace type="EDUSURV" if type==""

		}

	}
	
replace sample="SAMPLE_AER" if sample==""
	
drop if parm=="_cons"

replace  parm="reformMP" if  parm=="treat9"
replace  parm="reformMP" if  parm=="reformMP2"

label define ses 1 "Pooled" 2 "Low SES/FE" 3 "High SES/FE"
label value ses ses

save    "results_JAE.dta", replace
