/*Figure 2*/

  /*Graphics Setting*/
set scheme s1mono
*graph set window fontface "Garamond"
graph set window fontface "Times New Roman"
 set more off 

global size size(large)
global ls labsize(medlarge)
global legs size(medlarge)

 

  /*Graph Fathers Education*/ 
 
*cd "$output"
*dir 
 

/*Identify movers from Income Data*/ 
 
  use "$data\cx4853tab23.dta", clear
keep  q1 allref allcon id
bysort id (q1): keep if _n==1
 save "$data\nomove.dta", replace
  

**Read In original Data File MP(2005)** 
 
  use "$data\cx4853tab1.dta", clear

  merge 1:1 id using  "$data\nomove.dta"		/*Identify movers*/
 
	gen kommun60=fk
	cap drop _m
	merge m:1 kommun60 using "$reformdata\slutgiltiga_reformkommuner_fob60.dta"	/*Reform Data Holmund (2008)*/
  
rename reform treat9
rename fk muniid
gen cohort=1948 if d53==0
replace cohort=1953 if d53==1

rename female sex
recode sex (1=0) (0=1)

 
xtset muniid
 global regopt2 "fe vce(cluster muniid)"
 
  
 *cap drop fed*
  tab fe 

cap drop fe2 
gen fe2=fe  
replace fe2 =0 if fe>8 
replace fe2 =3 if fe==4 

tab fe2 fe

cap drop fed*
tab fe2, gen(fed)
 
 global dependent "fed1 fed2 fed3 fed4" 
 
/*Holmlund (2008) Reform Assignment (hra)*/ 
 
  cap drop treat9b
 gen treat9b=(cohort>=firstcohort60)
 
 /*Descriptive Table*/  
  
    global y "fed1 fed2 fed3 fed4"
  
  estpost su $y   
	est sto F1
 
 
    #delimit ;
 estout F1 using   fatherEDUC.tex , cells(mean(fmt(3))) style(tex)	
				mlabels(,none) collabels(,none) eqlabels(,none) label unstack replace
 	   ;
  #delimit cr
  
/* Excluding movers of reform status */
**MP: Dofile aerdofile (line 569-576) 
 cap drop aa
 gen aa=0
replace aa=1 if q1==1 & treat9 ==0
replace aa=1 if q1==2 & treat9 ==1
 
**Main Specification 
 
 cd "$results"
 
 foreach i of global dependent {
 
xtreg `i' cohort##sex    treat9 , $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'.dta,replace )  
 
 }
 
**Holmlund Assignment 
 
 foreach i of global dependent {
 
xtreg `i' cohort##sex    treat9b , $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'_hra.dta ,replace )  
 
 } 
 
**Remove Movers as in MP (2005) 
 
  foreach i of global dependent {
 
xtreg `i' cohort##sex    treat9 if   aa==0, $regopt2
  parmest ,format(estimate min95 max95)    saving(nomove`i'.dta, replace)  
 
 }
 
 cd "$globalpath"
  
 *************************
/*Plot Fathers Education*/ 
**************************  
**Main Specification  / AER Data
 
use "$results\fed1.dta", clear
 gen years=1
append using "$results\fed2.dta"
 replace years=4 if years==.
append using "$results\fed3.dta" 
replace years=7 if years==.
append using "$results\fed4.dta"
 replace years=10 if years==.
 
 
 gen spec=1
 
**Remove Movers as in MP (2005)  / AER Data
 
append using "$results\nomovefed1.dta"
 replace years=1  if years==.
append using "$results\nomovefed2.dta"
 replace years=4 if years==.
append using "$results\nomovefed3.dta" 
replace years=7 if years==.
append using "$results\nomovefed4.dta" 
 replace years=10 if years==.
 
  
 replace spec=2 if spec==. 
  
  append using "$results\UGU_fed1_reformMP2_all.dta"
 replace years=1  if years==.
append using "$results\UGU_fed2_reformMP2_all.dta"
 replace years=4 if years==.
append using "$results\UGU_fed3_reformMP2_all.dta" 
replace years=7 if years==.
append using "$results\UGU_fed4_reformMP2_all.dta" 
 replace years=10 if years==.
 
  
 replace spec=3 if spec==.
 
   append using "$results\UGU_fed1_treat9b_all.dta"
 replace years=1  if years==.
append using "$results\UGU_fed2_treat9b_all.dta"
 replace years=4 if years==.
append using "$results\UGU_fed3_treat9b_all.dta" 
replace years=7 if years==.
append using "$results\UGU_fed4_treat9b_all.dta" 
 replace years=10 if years==.
 
  
 replace spec=4 if spec==.
 
**Holmlund Assignment / AER Data
  
 append using "$results\fed1_hra.dta"
 replace years=1  if years==.
append using "$results\fed2_hra.dta"
 replace years=4 if years==.
append using "$results\fed3_hra.dta" 
replace years=7 if years==.
append using "$results\fed4_hra.dta" 
 replace years=10 if years==.
 
  
 replace spec=5 if spec==.
 
  append using "$results\fed1_alt.dta"
 replace years=1  if years==.
append using "$results\fed2_alt.dta"
 replace years=4 if years==.
append using "$results\fed3_alt.dta" 
replace years=7 if years==.
append using "$results\fed4_alt.dta" 
 replace years=10 if years==.
 
  
 replace spec=6 if spec==.
   
  keep if parm=="treat9" | parm=="treat9b" | parm=="treat9c" | parm=="reformMP2"
 
  replace years=years-0.15 if spec==1
 replace years=years  if spec==2
 replace years=years+0.15  if spec==3
 
 replace years=years+0.85 if spec==4
 replace years=years +1	 if spec==5
 replace years=years+1.15 if spec==6
  
  
  /*Graphics Setting
set scheme s1mono
*graph set window fontface "Garamond"
graph set window fontface "Times New Roman"

global size size(large)
global ls labsize(medlarge)
global legs size(medlarge)
 */

 
  
#delimit ;
 graph tw 
	(rspike min95 max95 years  if spec==1, color(gray) fintensity(40) ) (scatter estimate years if spec==1 , msym(Oh)) 
	(rspike min95 max95 years  if spec==2, color(gray) fintensity(40) ) (scatter estimate years if spec==2 , msym(Dh)) 
	(rspike min95 max95 years  if spec==3, color(gray) fintensity(40) ) (scatter estimate years if spec==3 , msym(Th) ) 
	
	(rspike min95 max95 years  if spec==4, color(gray) fintensity(40) ) (scatter estimate years if spec==4 , msym(O) ) 	 
 	(rspike min95 max95 years  if spec==5, color(gray) fintensity(40) ) (scatter estimate years if spec==5 , msym(T) ) 
	(rspike min95 max95 years  if spec==6, color(gray) fintensity(40) ) (scatter estimate years if spec==6 , msym(S) ) 
  
 , 
	ytitle("Reform Effect", $size) yline(0)
	xtitle("", )
				xscale( range(0.5 4.5)   )
				xlab( 1.5 "Missing" 4.5 "Compulsory" 7.5 "Secondary" 10.5 "Higher Secondary", nogrid angle(0) $ls )
				legend(order(2 "School (AER)"  4  "School / No Movers (AER)" 6   "School (UGU)"  8   "Municip. (AER)" 10  "Municip. (UGU)" 12 "Municip.  (SIP)") title("Reform Assignment")  $legs  col(3) position(10) ring(0) symx(4) region(col(white)))
						yscale( range(-0.06  .12)  noex )
						ylab(-0.06(0.03).12   ,  $ls nogrid  format(%5.2f) angle(0))
				graphregion(color(white) lwidth(large)) 
					bgcolor(white)	
						xscale( range(0  12)  noex )
					 
 			;
#delimit cr	

 

graph export "$graphs\pareduch_nomovpart.pdf", replace
 
