***********************************************************************************************************
** this do file generates regression tables
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off
set scheme s1mono

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

set seed 1989

**==============================================================================
*use $working_data/sampleMatch.dta, clear
import delimited $working_data/match.csv, case(preserve) clear

gen logedr = log(edr)
label variable logedr "log(EDR)"
label variable hunger "Hunger before age 5"
label variable fLiterate "Mother literate"

gen age20102 = age2010^2/100
label variable age20102 "Age squared(/100)"

*Table 3
eststo clear
regress hunger logedr, cl(birthProv)
eststo A
regress hunger logedr fLiterate age2010*, cl(birthProv)
eststo B
regress hunger logedr if male == 0, cl(birthProv)
eststo C
regress hunger logedr fLiterate age2010* if male == 0, cl(birthProv)
eststo D
regress hunger logedr if male == 1, cl(birthProv)
eststo E
regress hunger logedr fLiterate age2010* if male == 1, cl(birthProv)
eststo F
return list
esttab A B C D E F, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

**==============================================================================
*use $working_data/sampleHealth.dta, clear
import delimited $working_data/health.csv, case(preserve) clear

label variable logedr "log(EDR)"
label variable hunger "Hunger before age 5"
label variable fLiterate "Mother literate"

*Table 4
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

preserve
drop if birthy == 1962

*Table 5b
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace keep(hunger) b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

restore

egen quar = xtile(edr), nq(4)
gen quart2 = (quar==2)
gen quart3 = (quar==3)
gen quart4 = (quar==4)

*Table 5d
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = quart*) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = quart*) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = quart*) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = quart*) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace keep(hunger) b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

preserve
drop if birthProv ~= provcd

*Table 5c
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace keep(hunger) b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

restore

*Table b2
eststo clear
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 logedr if male == 0 & aux == 1, cl(birthProv)
eststo A
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 logedr fLiterate age* if male == 0 & aux == 1, cl(birthProv)
eststo B
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 logedr if male == 1 & aux == 1, cl(birthProv)
eststo C
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 logedr fLiterate age* if male == 1 & aux == 1, cl(birthProv)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b3b
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = edr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = edr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = edr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = edr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b1a
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls diabetes (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls hypt (hunger = logedr) if male == 0, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls obesity (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b1b
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1 (hunger = logedr) if male == 1, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls diabetes (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls hypt (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls obesity (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b5
eststo clear
bootstrap _b, reps(999) cluster(birthProv): ts2sls hospiVisitN (hunger = logedr) if male == 0, group(aux)
eststo A
bootstrap _b, reps(999) cluster(birthProv): ts2sls hospiVisitN (hunger = logedr) fLiterate age* if male == 0, group(aux)
eststo B
bootstrap _b, reps(999) cluster(birthProv): ts2sls hospiVisitN (hunger = logedr) if male == 1, group(aux)
eststo C
bootstrap _b, reps(999) cluster(birthProv): ts2sls hospiVisitN (hunger = logedr) fLiterate age* if male == 1, group(aux)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b6
eststo clear
bootstrap _b, reps(999) cluster(birthProv): regress hospiVisitN stdcount1 if male == 0 & aux == 1, cl(birthProv)
eststo A
bootstrap _b, reps(999) cluster(birthProv): regress hospiVisitN stdcount1 fLiterate age* if male == 0 & aux == 1, a(birthProv) cl(birthProv)
eststo B
bootstrap _b, reps(999) cluster(birthProv): regress hospiVisitN stdcount1 if male == 1 & aux == 1, cl(birthProv)
eststo C
bootstrap _b, reps(999) cluster(birthProv): regress hospiVisitN stdcount1 fLiterate age* if male == 1 & aux == 1, a(birthProv) cl(birthProv)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b4a
eststo clear
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger if male == 0 & aux == 1, cl(birthProv)
eststo A
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger fLiterate age* if male == 0 & aux == 1, cl(birthProv)
eststo B
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger if male == 1 & aux == 1, cl(birthProv)
eststo C
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger fLiterate age* if male == 1 & aux == 1, cl(birthProv)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)

*Table b4b
eststo clear
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger_own if male == 0 & aux == 1, cl(birthProv)
eststo A
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger_own fLiterate age* if male == 0 & aux == 1, cl(birthProv)
eststo B
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger_own if male == 1 & aux == 1, cl(birthProv)
eststo C
bootstrap _b, reps(999) cluster(birthProv): regress stdcount1 hunger_own fLiterate age* if male == 1 & aux == 1, cl(birthProv)
eststo D
return list
esttab A B C D, replace b(a2) se(a2) label noconstant nolines nogaps compress fragment nonumbers mlabels(none) collabels() stats(N1, labels("Observations")) starlevels(* 0.10 ** 0.05 *** 0.01)




