***********************************************************************************************************
** this do file merges the sample with health data
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off
set scheme s1mono

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
use $working_data/sampleMatch.dta, clear

gen logedr = log(edr)
label variable logedr "log(EDR)"
label variable hunger "Hunger before age 5"
label variable fLiterate "Mother literate"

merge 1:m pid using "$working_data/healthCFPS.dta"
keep if _merge == 3
drop _merge

drop age2010*
gen time = birthy - 1950
gen age = 2010 - birthy if wave == 1
replace age = 2012 - birthy if wave == 2
replace age = 2014 - birthy if wave == 3
gen age2 = age^2/100

label variable age "Age"
label variable age2 "Age squared(/100)"

local health "diabetes hypt obesity"
foreach var in `health' {
	sum  `var'
	local `var'_mean = r(mean)
	local `var'_sd = r(sd)
	gen std_`var' = (`var' - ``var'_mean')/``var'_sd'
}

gen stdcount1 = (std_diabetes+std_hypt+std_obesity)/3
label variable stdcount1 "Metabolic syndrome(index)"
label variable hunger "Hunger before age 5"

expand 2, gen(aux)
replace aux = aux+1
drop if aux == 2 & wave ~= 1

merge m:1 pid using "$working_data/famine_own.dta"
keep if _merge == 3
drop _merge

save $working_data/sampleHealth.dta, replace

/*
**==============================================================================
keep if male == 0

frame create conley mean var
quietly{
	forvalues i = 0/20 {
		gen stdcount1_shuffled = stdcount1 - 0.001*`i'*logedr
		bootstrap _b, reps(999) cluster(birthProv): ts2sls stdcount1_shuffled (hunger = logedr) if male == 0, group(aux)
		frame post conley (_b[hunger]) (_se[hunger])
		drop stdcount1_shuffled
	}
}

frame conley: save $working_data/conley.dta, replace
*/



