***********************************************************************************************************
** this do file prepares the sample
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
use $raw_data/cfps2010adult.dta, clear
tostring pid, replace

gen hungerStart = qg101_a_56
replace hungerStart = . if hungerStart < 1000
gen hungerEnd = qg102_a_56
replace hungerEnd = . if hungerEnd < 1000

gen hunger = (hungerStart ~= . & hungerEnd ~= .)
gen hungerDur = hunger*(hungerEnd - hungerStart + 1)
replace hungerDur = 0 if hungerDur < 0
gen birthy = qa1y_best
gen birthm = qa1m
gen male = gender
gen a_pid = pid

gen party = (qa7_s_1==1)
gen lit = (qc1 > 1)
replace hunger = 0 if hungerStart > 1962

keep a_pid birthy male hunger hungerStart hungerEnd hungerDur cid party lit

save $working_data/famine.dta, replace

**==============================================================================
use $working_data/famine.dta, clear

rename a_pid pid
rename hunger hunger_own
keep pid hunger_own

save "$working_data/famine_own.dta", replace

**==============================================================================
use $raw_data/cfps2010comm_201906.dta, clear

gen village = (ca0 == 5)
gen switch = ce102_a_14 if ce102_a_14 > 0
gen distance = cg3 if cg3 > 0

keep cid village switch distance
save $working_data/village.dta, replace

**==============================================================================
use $raw_data/cfps2010adult.dta, clear
tostring pid, replace

gen birthy = qa1y_best
gen birthm = qa1m
replace birthm = . if birthm < 1

gen male = gender
gen birthProv = qa102acode
gen birthCounty = qa102c_code
gen birthRural = (qa302 == 1)
gen famineAge = 1962 - birthy

keep if birthy >= 1921 & birthy <= 1980

rename meduc mEduc
rename feduc fEduc
gen mLiterate = (mEduc ~= 1)
gen fLiterate = (fEduc ~= 1)
gen educ = cfps2010edu_best
replace educ = 1 if educ == -1

gen age2010 = 2010 - birthy
gen mAge = 2010 - mbirthy
label variable age2010 "Age at 2010"
label variable mAge "Mother's Age"
replace fbirthy = mbirthy if fbirthy == .

recode educ (1 = 1) (2 = 2) (3 = 3) (4/8 = 4)
recode mEduc (1 = 1) (2 = 2) (3 = 3) (4/8 = 4)
recode fEduc (1 = 1) (2 = 2) (3 = 3) (4/8 = 4)
label define education 1 "Illitarate" 2 "Primary" 3 "Junior" 4 "Senior and above", replace
label val educ education
tab educ, gen(educ_dum)
label variable educ_dum1 "Illitarate"
label variable educ_dum2 "Primary"
label variable educ_dum3 "Junior"
label variable educ_dum4 "Senior and above"

keep pid fid cid provcd countyid birthy birthm birthProv birthCounty birthRural famineAge ///
male educ* mbirthy fbirthy mEduc fEduc mLiterate fLiterate age2010 mAge

label variable birthy "Birth year"
label variable birthRural "Born in rural area"

label variable male "Male"
label define gender 0 "Female" 1 "Male", replace
label values male "Gender"

label variable educ "Education"
label variable fEduc "Father's education"
label variable mEduc "Mother's education"
label variable fLiterate "Father literate"
label variable mLiterate "Mother literate"
label variable mbirthy "Mother birth year"
label variable fbirthy "Father birth year"

merge m:1 cid using $working_data/village.dta
keep if _merge == 3
drop _merge

keep if village == 1
keep if birthRural == 1
drop if distance < 30
drop if mbirthy == .

save "$working_data/sampleRural.dta", replace

**==============================================================================
use "$working_data/sampleRural.dta", clear

keep if birthy <= 1962 & birthy >= 1957

save "$working_data/samplePrim.dta", replace

**==============================================================================
use "$working_data/sampleRural.dta", clear

keep if birthy < 1968 & birthy >= 1957
gen placebo = (birthy > 1963)

save "$working_data/samplePlacebo.dta", replace

**==============================================================================
use "$raw_data/cfps2010adult.dta", clear
tostring pid, replace

gen birthy = qa1y_best
gen birthm = qa1m
gen male = gender

keep if male == 0
keep if birthy <= 1947

gen mLiterate = (cfps2010edu_best > 1)
gen fLiterate = (sedu > 1) if sedu ~= .
gen m = 1

replace mbirthy = birthy
replace fbirthy = tb1y_a_s if tb1y_a_s > 0
label variable mbirthy "Mother birth year"
label variable fbirthy "Father birth year"
drop if fLiterate == .
drop if fbirthy == .

keep pid fid mbirthy fbirthy mLiterate fLiterate m cid countyid provcd
save "$working_data/aux1.dta", replace

**==============================================================================
use "$working_data/sampleRural.dta", clear

keep if birthy <= 1947
gen m = 0

keep pid fid mbirthy fbirthy mLiterate fLiterate m cid countyid provcd
save $working_data/aux2.dta, replace

**==============================================================================
use "$working_data/aux1.dta", clear
append using "$working_data/aux2.dta"

label variable fLiterate "Father literate"
label variable mLiterate "Mother literate"
gen aid = _n

save "$working_data/sampleAux.dta", replace

**==============================================================================
use "$working_data/samplePrim.dta", clear
gen prim = 1

append using "$working_data/sampleAux.dta"
replace prim = 0 if prim == .

merge m:1 cid using "$working_data/cid.dta"
keep if _merge == 3
drop _merge

tab fac, gen(fac_dum)
gen rank = 1-prim

capture noisily teffects nnmatch (provcd fac_dum1-fac_dum4 mbirthy mLiterate) (prim), ematch(countyid) dtolerance(0.7) gen(matchit) osample(os)

if _rc==459 {
    drop if os == 1
    drop os
}

teffects nnmatch (provcd fac_dum1-fac_dum4 mbirthy mLiterate) (prim), ematch(countyid) dtolerance(1) gen(matchit) osample(os)

gen a_pid = pid[matchit1[_n]]
gen a_aid = aid[matchit1[_n]]
drop matchit*
keep if prim == 1

merge m:1 a_pid using "$working_data/famine.dta"
keep if _merge == 3
drop _merge

merge m:1 birthProv using "$working_data/IV1.dta"
keep if _merge == 3
drop _merge

save "$working_data/sampleMatch.dta", replace

