

dates_Testmp=(dateslab(end-Test_minusp+1:end));
dates_Testmp=regexprep(dates_Testmp,'^19|^20','');
datestartstr=dates_Testmp{1};

b_savefig=true;


%% graph settings

step=24;
xtick=sort(Test_minusp:-step:1);
xticklabel=dates_Testmp(xtick);
FigW=16;FigH=20;


usedfont='Garamond';
fontaxsize=10;
qualitystr='-r200';


%% draw fact shock volatility

figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH/2.8],...
    'PaperPosition',[0,0,FigW,FigH/2.8],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);

fact_desc={'Global Inflation Volatility'};

for j=1:r
    
    subaxis(1,1,j,'Margin',.03,'MarginBottom',.17,'SpacingVertical',0.1,'SpacingHorizontal',0.05);
    
    cell_CHIs={ squeeze(qCHISdiag(j,:,2))   ,   squeeze(qCHISdiag(j,:,3))  ,  squeeze(qCHISdiag(j,:,4))      };
    plotband(cell_CHIs{:}  ,'g')
    set(gca,'XTick',xtick,'xticklabel',xticklabel)
    set(gca,'fontname',usedfont,'fontsize',fontaxsize+1,'XTickLabelRotation',45);
    axis tight
    grid on
    
end
if b_savefig
    print('-dpng',qualitystr,['./figures/' model '_SV_CHI_global_infla.png'])
end

%% draw total residual volatility

figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);


for j=1:n
    
    subaxis(5,4,j,'Margin',.06,'SpacingVertical',0.08,'SpacingHorizontal',0.04);
    
    cell_Omegasdiag={ squeeze(qOmegasdiag(j,:,2))   ,   squeeze(qOmegasdiag(j,:,3))  ,  squeeze(qOmegasdiag(j,:,4))      };
    plotband(cell_Omegasdiag{:}  ,'g')
    
    set(gca,'XTick',xtick,'xticklabel',xticklabel)
    set(gca,'fontname',usedfont,'fontsize',fontaxsize-1,'XTickLabelRotation',90);
    grid on
    axis tight
    title(short_desc{j},'fontname',usedfont,'fontsize',fontaxsize)
end

if b_savefig
    print('-dpng',qualitystr,['./figures/' model '_Omegas_diag_infla.png'])
end



%% volatility idio and factor

if 1
    
    dfig=figure;
    set(dfig,'color', 'white',...
        'PaperUnits','centimeters','PaperSize',[FigW FigH],...
        'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
        'Units','centimeters',...
        'Position',[0,0,FigW,FigH]);
    for j=1:n
        subaxis(5,4,j,'Margin',.06,'SpacingVertical',0.08,'SpacingHorizontal',0.05);
        
        plot(mOmegasdiag(j,:),'g')
        hold on
        plot(mdiagcomresidsVar(j,:),'r')
        plot(mdiagidiovar(j,:),'b')
        %plot(y_hat_flatp_insample(j,:),'g:')
        str_title=short_desc{j};
        axis tight
        grid on
        set(gca,'XTick',xtick,'xticklabel',xticklabel,'XTickLabelRotation',90)
        set(gca,'fontname',usedfont,'fontsize',fontaxsize-1);
        title(str_title,'fontname',usedfont,'fontsize',fontaxsize)
    end
    
    
    if b_savefig
        print('-dpng',qualitystr,['./figures/' model '_VolResdecomp_infla.png'])
    end
    
    
end


%% volatility idio and factor  (PERCENTAGE)


dfig=figure;
set(dfig,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','centimeters',...
    'Position',[0,0,FigW,FigH]);
for j=1:n
    subaxis(5,4,j,'Margin',.06,'SpacingVertical',0.08,'SpacingHorizontal',0.05);
    hold on
    
    areaplottanda=100*(squeeze(mshare_aggOmegaVar(j,:,:)));
    
    aa=area(areaplottanda);
    aa(1).EdgeColor='r';   aa(1).FaceColor='r';
    aa(2).EdgeColor='b';   aa(2).FaceColor='b';
    
    alpha(0.5)
    
    str_title=short_desc{j};
    axis tight
    grid on
    set(gca,'XTick',xtick,'xticklabel',xticklabel,'XTickLabelRotation',90)
    set(gca,'fontname',usedfont,'fontsize',fontaxsize-1);
    title(str_title,'fontname',usedfont,'fontsize',fontaxsize)
end


if b_savefig
    print('-dpng',qualitystr,['./figures/' model '_share_VolResdecompInfla.png'])
end



%% level decomposition


dfig=figure;
set(dfig,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','centimeters',...
    'Position',[0,0,FigW,FigH]);
for j=1:n
    
    subaxis(5,4,j,'Margin',.04,'MarginBottom',.07,'SpacingVertical',0.09,'SpacingHorizontal',0.04);
    
    X=[mY_ComComp(j,:)',mY_Idio(j,:)'];
    
    Xneg = X; Xneg(Xneg>0) = 0;
    Xpos = X; Xpos(Xpos<0) = 0;
    h1=bar(Xpos,1,'stack');hold on
    h2=bar(Xneg,1,'stack');
    
    h1(1).FaceColor = 'r'; h1(1).EdgeColor = 'none';
    h1(2).FaceColor = 'b'; h1(2).EdgeColor = 'none';
    h2(1).FaceColor = 'r'; h2(1).EdgeColor = 'none';
    h2(2).FaceColor = 'b'; h2(2).EdgeColor = 'none';
    
    alpha(0.5)
    
    h3=plot(Y_actual(j,:),'k');
    
    str_title=strcat(short_desc{j},{': '},sprintf('%2.1f',100*mRsqCom(j)),'%');
    axis tight
    grid on
    set(gca,'XTick',xtick,'xticklabel',xticklabel,'XTickLabelRotation',90)
    set(gca,'fontname',usedfont,'fontsize',fontaxsize-1);
    title(str_title{1},'fontname',usedfont,'fontsize',fontaxsize)
end


if b_savefig
    print('-dpng',qualitystr,['./figures/' model '_infla_leveldecomp.png'])
end

%% draw impulse response to global shock

figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);

YMAX=max(vec(qLocalProjComm(:,:,2:4)));
YMIN=min(vec(qLocalProjComm(:,:,2:4)));

for j=1:n
    
    subaxis(5,4,j,'Margin',.06,'SpacingVertical',0.06,'SpacingHorizontal',0.04);
    
    cell_qLocalProjComm={ squeeze(qLocalProjComm(j,1:21,2))   ,   squeeze(qLocalProjComm(j,1:21,3))  , squeeze(qLocalProjComm(j,1:21,4))     };
    plotband(cell_qLocalProjComm{:}  ,'g')
    set(gca,'fontname',usedfont,'fontsize',fontaxsize-1);
    grid on
    axis([1 numel( squeeze(qLocalProjComm(j,1:20,2))) 0 YMAX])
    title(short_desc{j},'fontname',usedfont,'fontsize',fontaxsize)
end

if b_savefig
    print('-dpng',qualitystr,['./figures/' model '_Response_CommShock_bands.png'])
end


