function [beta,yfitted,resids,Rsq]=quickOLS_Nointercept_omitNan(X,y)

% X is Txk
% y is Tx1

idnan=any([isnan(y),any(isnan(X),2)],2);
Xsel=X(not(idnan),:);
ysel=y(not(idnan),:);

XprX=Xsel'*Xsel;
Xpry=Xsel'*ysel;
beta=XprX\Xpry;

if and(nargout>1,nargout<3)
    yfitted=X*beta;
elseif nargout>2
    yfitted=X*beta;
    resids=y-yfitted;
    SSE=nansum(resids.^2);
    SST=nansum(ysel.^2);
    Rsq=1-(SSE/SST);
end