function [Omega,A_inv,Sigma]=make_TV_RF_covar_matrix(alpha,sigma)

%INPUTS   alpha is rxt or rx1  sigma nxt
%OUTPUTS  Omega is nxnxt
% Copyright (c) 2013-2018, Francesco Corsello, All Rights Reserved.

[r,talpha]=size(alpha);
[n,T]=size(sigma);

m=(1/2)*sqrt((8.*r+1))+(1/2);

    if m~=n
        error('inputs should be of the proper dimension!')   
    end



  A=make_tril_A_pages(alpha);
  
  if talpha>1
    cell_Ainv=arrayfun(@(t) eye(n)/A(:,:,t),1:T,'UniformOutput',false);
    A_inv=cell2mat(reshape(cell_Ainv,1,1,T));
  else
    A_inv=eye(n)/A;
  end

    Sigmasq=diagT(sigma.^2);
    A_inv_prime=permute(A_inv,[2 1 3]);
    Omega=mtimesx(A_inv,mtimesx(Sigmasq,A_inv_prime ) );

end
  
