function [gamma,a, b0_tilde,g, sigmas , Qs]=draw_from_prior_MAIAR_SV(prior,T)
%           prior the structure containing
%           prior.gamma_bar, prior.Vgamma
%           prior.a_bar, prior.Va    
%           prior.mb0,prior.vb0,
%           prior.g_bar, prior.Vg
%           prior.logsigma_bar ,prior.Ps_bar, prior.Qs_bar, prior.tau0s

n=size(prior.logsigma_bar,1);
r=n-size(prior.mb0,1);

gamma=transpose(mvnrnd(  prior.gamma_bar' ,  prior.Vgamma       ) );
a= transpose(mvnrnd(  prior.a_bar' ,  prior.Va       ) );
b0_tilde=prior.mb0+sqrt(prior.vb0).*randn(n-r,1);
g=transpose(mvnrnd(  prior.g_bar' ,  prior.Vg       ) );

Qs=iwishrnd(prior.Qs_bar, prior.tau0s);
vs=transpose(mvnrnd(zeros(1,n),0.01*Qs,T));
logsigma0=  transpose(mvnrnd(  prior.logsigma_bar' , make_sim_precise( prior.Ps_bar  )  ) );
sigmas=exp(repmat(logsigma0,1,T)+cumsum(vs,2));