if $boot == 1 {
*Run boottest to get bootstrapped clustered pvals and CIs for all coefficients
local _indep_vars: colnames e(b)
local n_vars= $nvars /*colsof e(b)****changed this to only 2, don't need to worry about controls and constants*/
local indep_hypotheses
local indep_vars
forval k = 1/$nvars { 
	local var: word `k' of `_indep_vars'
	local indep_vars = "`indep_vars' `var'"
	local indep_hypotheses = "`indep_hypotheses' {`var'}"
}
*display "`indep_vars'"
*display "indep_hypotheses"
boottest `indep_hypotheses', cluster($cluster) nograph $webb seed($seed) //boottest each coefficient 

*Store boottest output in e() matrices
matrix boot_pval  = J(1,`n_vars',.)
matrix boot_ci_lb = J(1,`n_vars',.)
matrix boot_ci_ub = J(1,`n_vars',.)
forval k = 1/$nvars { //Loop through predictors, aka matrix columns 
	cap noisily {
	matrix boot_pval[1,`k'] = r(p_`k')
	matrix CI_temp = r(CI_`k')
	matrix boot_ci_lb[1,`k'] = CI_temp[1,1]
	matrix boot_ci_ub[1,`k'] = CI_temp[1,2]
	}
}
foreach mat in "boot_pval" "boot_ci_lb" "boot_ci_ub" {
	matrix colnames `mat' = `indep_vars'
	estadd matrix `mat' = `mat': $name
}
}
