%function to compute fitted values using results from xnlsur to use in the
%computation of optimal instruments

function f=fittedonestep_onecons(x)
global alphaf3list alphaf4list alphaf5list alpham3list alpham4list alpham5list alphak3list alphak4list alphak5list betaf3list betam3list betak3list betaf4list betam4list betak4list betaf5list betam5list betak5list eta_z3list eta_z4list eta_z5list x3 x4 x5 tiny eta_k3list eta_k4list eta_k5list nkids3 nkids4 nkids5 sf_3 sf_4 sf_5 sm_3 sm_4 sm_5 sk_3 sk_4 sk_5 x3hat x4hat x5hat;

E3f=[x(1) x(2) x(3) x(4) x(5) x(6) x(7) x(8) x(9) x(10) x(11) x(12) x(13) x(14) x(15) x(16) x(17)];
E3m=[x(18) x(19) x(20) x(21) x(22) x(23) x(24) x(25) x(26) x(27) x(28) x(29) x(30) x(31) x(32) x(33) x(34)];
E4f=[x(35) x(36) x(37) x(38) x(39) x(40) x(41) x(42) x(43) x(44) x(45) x(46) x(47) x(48) x(49) x(50) x(51)];
E4m=[x(52) x(53) x(54) x(55) x(56) x(57) x(58) x(59) x(60) x(61) x(62) x(63) x(64) x(65) x(66) x(67) x(68)];
E5f=[x(69) x(70) x(71) x(72) x(73) x(74) x(75) x(76) x(77) x(78) x(79) x(80) x(81) x(82) x(83) x(84) x(85)];
E5m=[x(86) x(87) x(88) x(89) x(90) x(91) x(92) x(93) x(94) x(95) x(96) x(97) x(98) x(99) x(100) x(101) x(102)];
A3f=[x(103) x(104) x(105) x(106) x(107) x(108) x(109) x(110) x(111) x(112) x(113) x(114) x(115) x(116) x(117) x(118) x(119)];
A3m=[x(120) x(121) x(122) x(123) x(124) x(125) x(126) x(127) x(128) x(129) x(130) x(131) x(132) x(133) x(134) x(135) x(136)];
A3k=[x(137) x(138) x(139) x(140) x(141) x(142) x(143) x(144) x(145) x(146) x(147) x(148) x(149) x(150) x(151) x(152) x(153)];
A4f=[x(154) x(155) x(156) x(157) x(158) x(159) x(160) x(161) x(162) x(163) x(164) x(165) x(166) x(167) x(168) x(169) x(170)];
A4m=[x(171) x(172) x(173) x(174) x(175) x(176) x(177) x(178) x(179) x(180) x(181) x(182) x(183) x(184) x(185) x(186) x(187)];
A4k=[x(188) x(189) x(190) x(191) x(192) x(193) x(194) x(195) x(196) x(197) x(198) x(199) x(200) x(201) x(202) x(203) x(204)];
A5f=[x(205) x(206) x(207) x(208) x(209) x(210) x(211) x(212) x(213) x(214) x(215) x(216) x(217) x(218) x(219) x(220) x(221)];
A5m=[x(222) x(223) x(224) x(225) x(226) x(227) x(228) x(229) x(230) x(231) x(232) x(233) x(234) x(235) x(236) x(237) x(238)];
A5k=[x(239) x(240) x(241) x(242) x(243) x(244) x(245) x(246) x(247) x(248) x(249) x(250) x(251) x(252) x(253) x(254) x(255)];
Bf=[x(256) x(257) x(258) x(259) x(260) x(261) x(262) x(263) x(264) x(265) x(266) x(267) x(268) x(269) x(270) x(271) x(272)];
Bm=[x(273) x(274) x(275) x(276) x(277) x(278) x(279) x(280) x(281) x(282) x(283) x(284) x(285) x(286) x(287) x(288) x(289)];
Bk=[x(290) x(291) x(292) x(293) x(294) x(295) x(296) x(297) x(298) x(299) x(300) x(301) x(302) x(303) x(304) x(305) x(306)];

eta3f_nlsur=[eta_k3list eta_z3list];
eta3m_nlsur=[eta_k3list eta_z3list];
eta4f_nlsur=[eta_k4list eta_z4list];
eta4m_nlsur=[eta_k4list eta_z4list];
eta5f_nlsur=[eta_k5list eta_z5list];
eta5m_nlsur=[eta_k5list eta_z5list];

em3=E3m*eta3m_nlsur';
ef3=E3f*eta3f_nlsur';
ef4=E4f*eta4f_nlsur';
em4=E4m*eta4m_nlsur';
ef5=E5f*eta5f_nlsur';
em5=E5m*eta5m_nlsur';

af3=A3f*alphaf3list';
af4=A4f*alphaf4list';
af5=A5f*alphaf5list';
am3=A3m*alpham3list';
am4=A4m*alpham4list';
am5=A5m*alpham5list';
ak3=A3k*alphak3list';
ak4=A4k*alphak4list';
ak5=A5k*alphak5list';


bf3=Bf*betaf3list';
bm3=Bm*betam3list';
bk3=Bk*betak3list';
bf4=Bf*betaf4list';
bm4=Bm*betam4list';
bk4=Bk*betak4list';
bf5=Bf*betaf5list';
bm5=Bm*betam5list';
bk5=Bk*betak5list';

sf3hat=(ef3'.*(af3'+bf3'.*(x3hat+log(ef3'))));
sm3hat=(em3'.*(am3'+bm3'.*(x3hat+log(em3'))));
sk3hat=((ones(size(x3,1),1)-ef3'-em3').*(ak3'+bk3'.*(x3hat+log(ones(size(x3,1),1)-ef3'-em3')-log(nkids3))));
sf4hat=(ef4'.*(af4'+bf4'.*(x4hat+log(ef4'))));
sm4hat=(em4'.*(am4'+bm4'.*(x4hat+log(em4'))));
sk4hat=((ones(size(x3,1),1)-ef4'-em4').*(ak4'+bk4'.*(x4hat+log(ones(size(x3,1),1)-ef4'-em4')-log(nkids4))));
sf5hat=(ef5'.*(af5'+bf5'.*(x5hat+log(ef5'))));
sm5hat=(em5'.*(am5'+bm5'.*(x5hat+log(em5'))));
sk5hat=((ones(size(x3,1),1)-ef5'-em5').*(ak5'+bk5'.*(x5hat+log(ones(size(x3,1),1)-ef5'-em5')-log(nkids5))));

f=[sf3hat sm3hat sk3hat sf4hat sm4hat sk4hat sf5hat sm5hat sk5hat ef3' em3' ef4' em4' ef5' em5' bf3' bm3' bk3' bf4' bm4' bk4' bf5' bm5' bk5'];