clear all
set more off
cd C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results


****************************************
*Panel A*
****************************************
use "$IN/sample_3wages_comuna.dta", clear

gen train_bin_t2_1 = train_bin_t2 if train_bin_t1 == 1
gen train_bin_t2_0 = train_bin_t2 if train_bin_t1 == 0



eststo: qui reg lnmosal_t2 train_bin_t1
eststo: qui reg lnmosal_t2 train_bin_t1 mate verbal ptje_nem d_sexo ageatentry ageatentry2
estadd local controls "X"

eststo: qui reg lnmosal_t3 train_bin_t2_1
eststo: qui reg lnmosal_t3 train_bin_t2_1 mate verbal ptje_nem d_sexo ageatentry ageatentry2
estadd local controls "X"

eststo: qui reg lnmosal_t3 train_bin_t2_0
eststo: qui reg lnmosal_t3 train_bin_t2_0 mate verbal ptje_nem d_sexo ageatentry ageatentry2
estadd local controls "X"

esttab using $Results/Table3_A.tex, keep(train_bin_t1 train_bin_t2_1 train_bin_t2_0) se coeflabels(train_bin_t1 "\$D_{i1}\$" train_bin_t2_1 "\$D_{i2}(1)\$" train_bin_t2_0 "\$D_{i2}(0)\$") star(* 0.05 ** 0.01 *** 0.001 ) stats(controls N, label("Controls" "Observations") fmt(0 %16.0gc)) b(3) mlabels(none) collabels(none)

eststo clear 
cap drop _*


****************************************
*Panel B*
****************************************
use "$IN/sample_3wages_comuna.dta", clear

gen switcher_t2 = ( employer_t2~= employer_t1)
gen switcher_t3 = ( employer_t3~= employer_t2)

la var d_sexo "Male"
la var ageatgrad "Age at Graduation"
la var mate "Math"
la var verbal "Verbal"
la var ptje_nem "GPA"


keep rut train_bin_t1 train_bin_t2  mate verbal ptje_nem d_sexo ageatentry ageatentry2 lnmosal_t1 lnmosal_t2 lnmosal_t3 treeobs switcher* employer_*
expand 2
sort rut
egen year = seq(), by(rut)
gen training = train_bin_t1
replace training = train_bin_t2 if year == 2

gen salary = lnmosal_t2
replace salary = lnmosal_t3 if year == 2

gen firm = employer_t2 
replace firm = employer_t3 if year == 2

gen switcher = switcher_t2 
replace switcher = switcher_t3 if year == 2

egen switch_tot = total(switcher), by(rut)
replace switch_tot = 1 if switch_tot >= 1

tsset rut year

gen train_fd = training-training[_n-1] if year == 2
gen salary_fd = salary-salary[_n-1] if year == 2

la var training "Training"
la var ageatentry "Age"
la var ageatentry2 "Age^2"

eststo clear

****OLS****
qui reg salary training
est sto m1
local beta_1 = string(round(_b[training],0.001),"%9.3f")
local se_1 = string(round(_se[training],0.001),"%9.3f")
local n_1 = string(e(N),"%9.0f")
local r2_1 = string(round(e(r2),0.01),"%9.2f")
qui: test training=0
local pval_1 = r(p)


****OLS WITH CONTROL VARIABLES****
qui reg salary training mate verbal ptje_nem d_sexo ageatentry ageatentry2
est sto m2
local beta_2 = string(round(_b[training],0.001),"%9.3f")
local se_2 = string(round(_se[training],0.001),"%9.3f")
local n_2 = string(e(N),"%9.0f")
local r2_2 = string(round(e(r2),0.01),"%9.2f")
qui: test training=0
local pval_2 = r(p)

****FIRST DIFFERENCES****
*reg D.(salary training), nocons
qui reg salary training mate verbal ptje_nem d_sexo ageatentry ageatentry2 lnmosal_t1
est sto m3
local beta_3 = string(round(_b[training],0.001),"%9.3f")
local se_3 = string(round(_se[training],0.001),"%9.3f")
local n_3 = string(e(N),"%9.0f")
local r2_3 = string(round(e(r2),0.01),"%9.2f")
qui: test training=0
local pval_3 = r(p)

***FIRM FE***
qui xtreg salary training i.year, fe
est sto m5
local beta_4 = string(round(_b[training],0.001),"%9.3f")
local se_4 = string(round(_se[training],0.001),"%9.3f")
local n_4 = string(e(N),"%9.0f")
local r2_4 = string(round(e(r2),0.01),"%9.2f")
qui: test training=0
local pval_4 = r(p)

*Pvalues*
forvalues x=1/4{

	if `pval_`x''<=0.001{
		local label_pval_`x' = "***"
	}
	else if `pval_`x''<=0.01{
		local label_pval_`x' = "**"
	}
	else if `pval_`x''<=0.05{
		local label_pval_`x' = "*"
	}
	else{
		local label_pval_`x' = ""
	}
	
}
**writing table
file open reduced using $Results/Table3_B.tex, write replace
file write reduced "\begin{tabular}{lrccccccc}" _n
file write reduced "\hline" _n
file write reduced "      &       & (1)   &       & (2)   &       & (3)   &       & (4)    \bigstrut\\" _n

file write reduced "  \cline{1-1}\cline{3-9}"
file write reduced "Effect of training &&  `beta_1'`label_pval_1'  && `beta_2'`label_pval_2' &&  `beta_3'`label_pval_3'  &&    `beta_4'`label_pval_4'  \bigstrut[t]\\" _n
file write reduced "      &&  (`se_1') &&  (`se_2')     &&   (`se_3')    &&  (`se_4')      \bigstrut[b]\\" _n
file write reduced " \hline " _n
file write reduced " OLS   &       & X     &       &       &       &       &       &        \bigstrut[t]\\" _n
file write reduced " OLS + controls &       &       &       & X     &       &       &       &        \\" _n
file write reduced " OLS + initial wage &       &       &       &       &       & X     &       &       \\" _n
file write reduced "Individual  FE &       &       &       &       &       &       &       & X      \\" _n
file write reduced " \hline " _n
file write reduced " Observations (\$N\times T\$) && `n_1' &&  `n_2'     &&  `n_3'     &&  `n_4'     \bigstrut[t]\\" _n
file write reduced "\hline" _n
file write reduced "\end{tabular}%" _n
file close reduced

