clear all
set more off
set scheme s1mono

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates

local nobs = 500
set seed 14382

**************************
*Factor Distribution*
foreach x in prod test{
infile mu1 mu2  tao1 tao2  p1 p2   using $IN/fac_`x'.out, clear
mkmat mu1 mu2  tao1 tao2  p1 p2 , mat(f_`x')
}

**************************
*Control Variables for Measurement System (Test Scores)*
global tvars "constant d_sexo ageatgrad hhsize educmom educdad employeddad employedmom"

foreach x in  mate verbal nem {
infile $tvars prod test error using "$IN/`x'.out", clear
mkmat $tvars prod test error, mat(B_`x')
}

**************************
*Control Variables for Measurement System (Initial Wages)*
global twvars "constant d_sexo ageatentry yentry1 yentry2 yentry3 yentry4 yentry5"

*foreach x in salary_X1 salary_X2 salary_X3 { 
foreach x in salary_X1 salary_X2 { 
infile $twvars prod test error using "$IN/`x'.out", clear
mkmat $twvars prod test error, mat(B_`x')
}

**************************
*Control Variables for Probits*
global z1vars "constant d_sexo ageatentry hoursfirm_t1 hoursfirm_t1_com wage_comuna_entry"
global z10vars "constant d_sexo ageatentry hoursfirm_t2 hoursfirm_t2_com wage_comuna_entry"
global z11vars "constant d_sexo ageatentry hoursfirm_t2 hoursfirm_t2_com wage_comuna_entry"

*Control Variables for DPRTE*
global z1vars_prte1 "constant d_sexo ageatentry hoursfirm_t1 z1prte1 wage_comuna_entry"
global z1vars_prte2 "constant d_sexo ageatentry hoursfirm_t1 z1prte2 wage_comuna_entry"

foreach x in 1 10 11  {
infile ${z`x'vars} prod test error using "$IN/training_`x'.out", clear
mkmat ${z`x'vars} prod test error, mat(B_training`x')
}

**************************
*Control Variables for Outcomes: Wages*
global yvars "constant d_sexo ageatentry ageatentry2 yentry1 yentry2 yentry3 yentry4 yentry5 wage_comuna_entry"

foreach x in  salary_00 salary_01 salary_10 salary_11 salary_0 salary_1  {
infile $yvars prod test error using "$IN/`x'.out", clear
mkmat $yvars prod test error, mat(B_`x')
}


********************************************************************************
*2. get data
use "$IN/sample_3wages_comuna.dta", clear

*Replacing initial salaries to be in logs (as in .raw data for estimation)*
foreach x in mosal_usd_wage1 mosal_usd_wage2 mosal_usd_wage3 mosal_usd_wage4{
replace `x' = log(`x')
}


foreach x of varlist * {
replace `x' = . if `x' == -999
}

global prte_size1 = "1.1"
global prte_size2 = "1.5"
gen z1prte1 = hoursfirm_t1_com * $prte_size1
gen z1prte2 = hoursfirm_t1_com * $prte_size2


** 3. Draw betas-independientes
gen nobsinsim=.
forval i= 1/20{
	scalar unibeta=ceil(runiform()*`nobs')
	scalar unitheta= unibeta
		
		preserve
			do "$IN/inner.do"	
		compress
		save "$IN/temp`i'_`i'.dta",replace				
restore
}

clear

use "$IN/temp1_1.dta", clear
forvalues i=2(1)20{
	append using "$IN/temp`i'_`i'.dta"
}

foreach x in prod test{
xtile `x'10 = f_`x', nq(10)
}

save "$IN/simdata.dta", replace

forvalues i=1(1)20{
 	erase "$IN/temp`i'_`i'.dta"
}
