*set obs 20000
set more off
count
replace nobsinsim=r(N)


********************************************************************************
*(1) Infiling Factor(s)*
********************************************************************************

foreach x in prod test {
local nf1=colsof(f_`x')

*Productivity and Test Score Factors*
scalar p12_`x'=f_`x'[unitheta,`nf1']
scalar p11_`x'=f_`x'[unitheta,`nf1'-1]
scalar sigf12_`x'=f_`x'[unitheta,`nf1'-2]
scalar sigf11_`x'=f_`x'[unitheta, `nf1'-3]
scalar mu12_`x'=f_`x'[unitheta,`nf1'-4]
scalar mu11_`x'=f_`x'[unitheta, `nf1'-5]
}


********************************************************************
foreach x in prod test {
	gen uni`x'=uniform()
	gen f_`x' = invnorm(uniform())*sqrt(1/sigf11_`x') + mu11_`x' if uni`x'<p11_`x'
	replace f_`x' = invnorm(uniform())*sqrt(1/sigf12_`x') + mu12_`x' if uni`x'>=p11_`x'
}


********************************************************************************
*(2.1) Measurement System: Test Scores*
********************************************************************************
*Infiling betas from test scores*
foreach x in  mate verbal nem  {
	mat A`x'=B_`x'[unibeta, 1...]
}


foreach x in  mate verbal nem  {

*ERROR TERMS AND FACTOR LOADINGS FOR TESTS*
local last=colsof(A`x')

*Factor Loading*
qui gen A_`x'_prod= A`x'[1,`last'-2]
qui gen `x'_fac_prod = A_`x'_prod*f_prod

qui gen A_`x'_test= A`x'[1,`last'-1]
qui gen `x'_fac_test = A_`x'_test*f_test

*Error Term*
scalar tao_`x' =A`x'[1,`last']
qui gen eps_`x'=invnorm(uniform())*sqrt(1/tao_`x') 
}

******************************************************

*tests
local c=0
local testvars $tvars
foreach su in mate verbal nem   {
	qui gen cov_`su'=0
	qui gen addvar_`su'=0
}

foreach X in `testvars'{
local c=`c'+1
foreach z in mate verbal nem   {
		replace addvar_`z'=A`z'[1,`c']*`X'
		replace cov_`z'=cov_`z'+addvar_`z' 
	}
}
drop addvar*


********************************************************************************
*(2.2) Measurement System: Initial Wages*
********************************************************************************
*Infiling betas from test scores*
foreach x in  salary_X1 salary_X2  {

	mat A`x'=B_`x'[unibeta, 1...]
}


foreach x in  salary_X1 salary_X2  {

*ERROR TERMS AND FACTOR LOADINGS FOR TESTS*
local last=colsof(A`x')

*Factor Loading*
qui gen A_`x'_prod= A`x'[1,`last'-2]
qui gen `x'_fac_prod = A_`x'_prod*f_prod

qui gen A_`x'_test= A`x'[1,`last'-1]
qui gen `x'_fac_test = A_`x'_test*f_test

*Error Term*
scalar tao_`x' =A`x'[1,`last']
qui gen eps_`x'=invnorm(uniform())*sqrt(1/tao_`x') 
}

******************************************************

*tests
local c=0
local testvars $twvars

foreach su in  salary_X1  salary_X2  {
	qui gen cov_`su'=0
	qui gen addvar_`su'=0
}

foreach X in `testvars'{
local c=`c'+1

foreach z in  salary_X1  salary_X2  {
		replace addvar_`z'=A`z'[1,`c']*`X'
		replace cov_`z'=cov_`z'+addvar_`z' 
	}
}
drop addvar*


********************************************************************************
*(3) DECISIONS*
********************************************************************************

**************************************************************************
*Infiling Training Decisions*
**************************************************************************
foreach i in 1 10 11 {
	mat Bm`i' = B_training`i'[unibeta, 1...]
	local coll=colsof(Bm`i')
	qui gen epsm`i' = invnorm(uniform())*sqrt(1)
	
	qui gen covm`i' = 0
	qui gen addvarm`i' = 0

local c=0
local n`i' ${z`i'vars}

foreach X in `n`i''{
	local c=`c'+1
		
		replace addvarm`i'=Bm`i'[1,`c']*`X'
		replace covm`i'=covm`i'+addvarm`i'
	}

}
drop addvar*

**************************************************************************
*Policy-Relevant Treatment Simulations*
**************************************************************************
foreach x in prte1 prte2{
	mat Bm1_`x' = B_training1[unibeta, 1...]
	local coll=colsof(Bm1_`x')
	
	qui gen covm1_`x' = 0
	qui gen addvarm1_`x' = 0

local c=0
local n`x' ${z1vars_`x'}

foreach X in `n`x''{
	local c=`c'+1
		
		replace addvarm1_`x'=Bm1_`x'[1,`c']*`X'
		replace covm1_`x'=covm1_`x'+addvarm1_`x'
	}
	
}
drop addvar*



**************************************************************************
*Simulating Decisions*
**************************************************************************
local tm1=colsof(Bm1)
qui gen  I1 = covm1 + Bm1[1,`tm1'-2]*f_prod  + Bm1[1,`tm1'-1]*f_test + epsm1
qui gen  D1 = (I1>0)

qui gen  I1_prte1 = covm1_prte1 + Bm1[1,`tm1'-2]*f_prod  + Bm1[1,`tm1'-1]*f_test + epsm1
qui gen  D1_prte1 = (I1_prte1>0)

qui gen  I1_prte2 = covm1_prte2 + Bm1[1,`tm1'-2]*f_prod  + Bm1[1,`tm1'-1]*f_test + epsm1
qui gen  D1_prte2 = (I1_prte2>0)


local tm2=colsof(Bm10)
qui gen  I2_0 = covm10 + Bm10[1,`tm2'-2]*f_prod  + Bm10[1,`tm2'-1]*f_test + epsm10
qui gen  D2_0 = (I2_0>0)

local tm2=colsof(Bm11)
qui gen  I2_1 = covm11 + Bm11[1,`tm2'-2]*f_prod  + Bm11[1,`tm2'-1]*f_test + epsm11
qui gen  D2_1 = (I2_1>0)


gen choicesim = .
replace choicesim = 1 if D1 == 0 & D2_0 == 0
replace choicesim = 2 if D1 == 0 & D2_0 == 1
replace choicesim = 3 if D1 == 1 & D2_1 == 0
replace choicesim = 4 if D1 == 1 & D2_1 == 1


********************************************************************************
*(4) Wages*
********************************************************************************
foreach i in 0 1 00 01 10 11{
	mat Bw_`i' = B_salary_`i'[unibeta, 1...]
	local last=colsof(Bw_`i')
	
	scalar tao_w_`i'=Bw_`i'[1,`last']
	qui gen b_test_w`i'=Bw_`i'[1,`last'-1]
	qui gen b_prod_w`i'=Bw_`i'[1,`last'-2]
	qui gen eps_w_`i' = invnorm(uniform())*sqrt(1/tao_w_`i')

	qui gen covw_`i' = 0
	qui gen addvarw_`i'= 0


local c=0
local w2vars $yvars

foreach X in `w2vars'{
	local c=`c'+1
		replace addvarw_`i'=Bw_`i'[1,`c']*`X'
		replace covw_`i'=covw_`i'+addvarw_`i'
	}
}
drop addvar*

foreach i in 0 1 00 01 10 11{
	local last2=colsof(Bw_`i')
	qui gen w`i' = covw_`i'  + Bw_`i'[1,`last2'-2]*f_prod  + Bw_`i'[1,`last2'-1]*f_test + eps_w_`i'
}

*Second-Year Salaries*
qui gen W_1 = .
qui replace W_1 = w0 if D1 == 0
qui replace W_1 = w1 if D1 == 1

*Third-Year Salaries*
qui gen W_2 = .
qui replace W_2 = w00 if choicesim == 1
qui replace W_2 = w01 if choicesim == 2
qui replace W_2 = w10 if choicesim == 3
qui replace W_2 = w11 if choicesim == 4



