clear all
set more off

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results



/*
Densities

This do-file computes estimated densities of unobserved ability
across choices

*/

****************************************************************
*FIGUREs: FACTOR DENSITY*
****************************************************************
use $IN/simdata.dta, clear

gen tree_sim = 0
replace tree_sim = 1 if D1 == 0 & D2_0 == 1
replace tree_sim = 10 if D1 == 1 & D2_1 == 0
replace tree_sim = 11 if D1 == 1 & D2_1 == 1

********************************************************************************
*Test Factor*
twoway (kdensity f_test,lwidth(thick)),/*
*/ ytitle("Density")  xtitle("Latent Ability ({&theta}{subscript:1})") /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.2)
graph export "$Results/fig_factor_density_test_2w.pdf", replace


twoway (kdensity f_test if tree_sim == 11, lcolor(black)  lwidth(medthick)) ///
(kdensity f_test if tree_sim == 10, lcolor(black)  lwidth(medthick)) ///
(kdensity f_test if tree_sim == 1, lcolor(black)  lwidth(medthick)) ///
(kdensity f_test if tree_sim == 0,lcolor(black)  lwidth(medthick) ), ///
legend(order(1 "Always-trained (1;1)" 2 "Trained Once (1;0)" 3 "Trained Once (0;1)" 4 "Never-trained (0;0)" )) ///
xtitle("Latent Ability ({&theta}{subscript:1})") ///
 ytitle("Density") ///
 ylabel(, nogrid) xlabel( , noticks)  ///
 graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white)) ///
 plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) ///
 scheme(s2mono) scale(1.2)
 
graph export "$Results/fig_factor_density_choices_test_2w.pdf", replace

********************************************************************************
*Productivity Factor*
twoway (kdensity f_prod,lwidth(thick)),/*
*/ ytitle("Density")  xtitle("Latent Productivity ({&theta}{subscript:2})") /*
*/ xlabel( , noticks) ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) /*
*/ scheme(s2mono) scale(1.2)
graph export "$Results/fig_factor_density_prod_2w.pdf", replace


twoway (kdensity f_prod if tree_sim == 11, lcolor(black)  lwidth(medthick)) ///
(kdensity f_prod if tree_sim == 10, lcolor(black)  lwidth(medthick)) ///
(kdensity f_prod if tree_sim == 1, lcolor(black)  lwidth(medthick)) ///
(kdensity f_prod if tree_sim == 0,lcolor(black)  lwidth(medthick) ), ///
legend(order(1 "Always-trained (1;1)" 2 "Trained Once (1;0)" 3 "Trained Once (0;1)" 4 "Never-trained (0;0)" )) ///
xtitle("Latent Productivity ({&theta}{subscript:2})") ///
 ytitle("Density") ///
 ylabel(, nogrid) xlabel( , noticks)  ///
 graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white)) ///
 plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) ///
 scheme(s2mono) scale(1.2)
 
graph export "$Results/fig_factor_density_choices_prod_2w.pdf", replace


