% Owyang, Piger, and Soques -- "Contagious Switching"

% This code generates the principal component for each country.

clear all; clc;

% Set working directory
cd(fileparts(matlab.desktop.editor.getActiveFilename))
addpath('functions')

% Data filename
model.loadfile = 'OPS_Data.xlsx';  

startindex = 1;

data.us = xlsread(model.loadfile,'US_Data');
data.us = 100*(log(data.us(startindex+1:end,:)) - log(data.us(startindex:end-1,:)));

pc = zeros(size(data.us,1),3);

[~,scoreUS] = ppca(data.us,3);
pc(:,1) = scoreUS(:,1);

data.can = xlsread(model.loadfile,'Canada_Data');
data.can = 100*(log(data.can(startindex+1:end,:)) - log(data.can(startindex:end-1,:)));

[~,scoreCA] = ppca(data.can,3);
pc(:,2) = scoreCA(:,1);

data.mex = xlsread(model.loadfile,'Mexico_Data');
data.mex = 100*(log(data.mex(startindex+1:end,:)) - log(data.mex(startindex:end-1,:)));

[~,scoreMX] = ppca(data.mex,3);
pc(:,3) = scoreMX(:,1);

