function [S] = OPS_UMS_S(priors,draw,data)

S = zeros(priors.T,priors.N);
for n = 1:priors.N
    S_hold = draw.S(:,n);
    T = priors.T;
    Y = data.x(n,:)';
    A = [eye(2) - draw.P{n}; ones(1,2)];
    prSS = (A'*A)\A'*[zeros(2,1);1];
    prSS = prSS(:,end);
    Pr_Z_int = prSS;
    
    Pr_Zt_t = zeros(2,T);
    Pr_Zt_t(:,1) = Pr_Z_int;
    Pr_Ztm1_tm1 = Pr_Z_int;
    
    for t = 2:T
        Pr_Zt_Ztm1_tm1 = zeros(2,2);
        Pr_Zt_Ztm1_tm1(1,:) = draw.P{n}(1,:) .* Pr_Ztm1_tm1';
        Pr_Zt_Ztm1_tm1(2,:) = draw.P{n}(2,:) .* Pr_Ztm1_tm1';
        % Expansion
        fcast = Y(t,1) - draw.mu(n,1);
        log_f_yt_Zt_Ztm1_tm1(1,1) = draw.sigsq(n,1) \ -0.5 * fcast * fcast;
        % Recession
        fcast = Y(t,1) - draw.mu(n,2);
        log_f_yt_Zt_Ztm1_tm1(2,1) =draw.sigsq(n,1) \ -0.5 * fcast * fcast;
        scale = max(log_f_yt_Zt_Ztm1_tm1);
        f_yt_Zt_tm1 = exp(log_f_yt_Zt_Ztm1_tm1 - scale*ones(2,1));
        f_prime = repmat(f_yt_Zt_tm1,1,2);
        pr_zz_t = f_prime .* Pr_Zt_Ztm1_tm1;
        f_yt_tm1 = sum(sum(pr_zz_t,1),2);
        Pr_Zt_Ztm1_t = pr_zz_t / f_yt_tm1;
        Pr_Zt_t(:,t) = sum(Pr_Zt_Ztm1_t,2);
        Pr_Ztm1_tm1 = Pr_Zt_t(:,t);
    end
    u = unifrnd(0,1) * ones(2,1);
    PR_ = cumsum(Pr_Zt_t(:,end));
    S(end,n) = find(le(u,PR_),1);
    % Smoother & Draw
    acc = 0; wait = 0; tries = 0;
    while acc == 0
        for t = T-1:-1:1
            % Smooth probability of Z_t based on realization of Z_t+1
            %         Pr_Ztp1_Zt = P(Z(t+1,1),:,t); % Transition probability
            Pr_Ztp1_Zt = draw.P{n}(S(t+1,n),:);
            Pr_Zt_Ztp1_t = Pr_Ztp1_Zt' .* Pr_Zt_t(:,t);
            if sum(Pr_Zt_Ztp1_t) == 0
                t = T;
                tries = tries + 1;
                error('filter1')
            else
                % Draw Z_t
                PR_ = Pr_Zt_Ztp1_t / sum(Pr_Zt_Ztp1_t);
                u = unifrnd(0,1) * ones(2,1);
                S(t,n) = find(le(u,cumsum(PR_)),1);
            end
            if tries > 100
                error('stop')
            end
        end
        Sk = zeros(T,2);
        for t = 1:T
            Sk(t,S(t,n)) = 1;
        end
        if all(sum(Sk,1) > 0.10*(T)) % Each state occurs at least 5% of time periods
            acc = 1;
        else
            wait = wait + 1;
        end
        if wait > 100
            acc = 1;
            S(:,n) = S_hold;
        end
    end
    
   
end

