function [priors,data,draw,results] = OPS_UMS_Priors(model)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Model Setup
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
priors = model;

data.x =  xlsread(priors.loadfile,'PCA')';

if priors.start_1980 == 1
    startdate = 76; % 1980 = 76, 1985 = 96
    data.x = data.x(:,startdate:end);
end

priors.N = size(data.x,1);
priors.T = size(data.x,2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prior Parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

priors.m0 = [1; -1];
priors.M0 = eye(2);

priors.r0 = 0;
priors.R0 = 1;

priors.d0 = 1;
priors.nu0 = 1;

priors.P0 = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize Draw Structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
draw.mu = [ones(priors.N,1), -1 * ones(priors.N,1)];
draw.rho = zeros(priors.N,1);
draw.sigsq = ones(priors.N,1);

p = 0.75;
q = (1-p)/(2 - 1);
for n = 1:priors.N
    draw.P{n} = q * ones(2,2);
    for k = 1:2
        draw.P{n}(k,k) = p;
    end
    T = priors.T;
    Sn= zeros(T,1);
    Sn(1,1) = unidrnd(2,1,1);
    for t = 2:T
        u = rand(1);
        Sn(t,1) = find(le(u,cumsum(draw.P{n}(:,Sn(t-1,1)))),1);
    end
    draw.S(:,n) = Sn;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Results structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
results.mu = zeros(priors.N,2,priors.Nkeep);
results.sigsq = zeros(priors.N,priors.Nkeep);
results.S = zeros(priors.T,priors.N,priors.Nkeep);
results.P = zeros(2,2,priors.N);

end

