function [P] = OPS_UMS_P(priors,draw,data)

for n = 1:priors.N
    P_hold = draw.P{n};
    T = priors.T;
    trmat = zeros(2,2);
    for t = 2:T
        trmat(draw.S(t,n),draw.S(t-1,n)) = trmat(draw.S(t,n),draw.S(t-1,n)) + 1;
    end
    
    sw = trmat + priors.P0;
    Pn = zeros(2,2);
    for i = 1:2
        y = gamrnd(sw(:,i),1);
        Pn(:,i) =  y  / sum(y);
    end
    
    if any(any(Pn == 1))
        Pn = P_hold;
    end
    
    if any(diag(Pn) < 0.10)
        Pn = P_hold;
    end
    
    P{n} = Pn;
end
end

