function [AUCUMS] = OPS_UMS_Main


% %   *********************************************************************
% %   Model Setup
% %   *********************************************************************
model.Nburn = 3000; % Number of Gibbs burn-in iterations
model.Nkeep = 1000; % Number of Gibbs iterations to keep
model.loadfile = 'OPS_Data.xlsx';
model.disp = 1; % Display iterations in Command Window? (Yes = 1; No = 0)
model.rho0 = 1;
model.HPI = 68;
model.start_1980 = 1;

% %   *********************************************************************
% %   Gibbs Sampler
% %   *********************************************************************
[priors,data,draw,results] = OPS_UMS_Priors(model);
if model.disp == 1
    progressbar
end
for i = 1:priors.Nburn + priors.Nkeep
    [draw.mu,draw.rho,draw.sigsq] = OPS_UMS_mu_rho_sig(draw,priors,data);
    [draw.S] = OPS_UMS_S(priors,draw,data);
    [draw.P] = OPS_UMS_P(priors,draw,data);  
    if i > priors.Nburn
        results = OPS_UMS_Results(priors,draw,results,i-priors.Nburn);
    end
    if model.disp == 1
        progressbar(i/(priors.Nburn+priors.Nkeep))
    end
end

post.mu = median(results.mu,3);
post.sigsq = median(results.sigsq,2);
post.PrS = mean(results.S-1,3);

PrR = post.PrS; % Probability of Recession

% Load OECD Recession Dates
data.S =  xlsread(priors.loadfile,'Recessions')';

if priors.start_1980 == 1
    data.S = data.S(:,77:end)';
else
    data.S = data.S(:,2:end)';
end

for n = 1:priors.N
    targets = data.S(:,n);
    outputs = PrR(:,n);
    [X,Y,T1,AUC] = perfcurve(targets,outputs,1);
    XOPS{n} = X;
    YOPS{n} = Y;
    AUCUMS(n,1) = AUC;
end

filename = ['OPS_UMS_Main'];
save(filename,'-v7.3')

end
