function [mu,rho,sigsq,h] = OPS_mu_rho_sig(draw,priors,data)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

mu = zeros(priors.N,2);
rho = zeros(priors.N,1);
sigsq = zeros(priors.N,1);
mu_hold = draw.mu;
rho_hold = draw.rho;
h_hold = draw.h;
for n = 1:priors.N
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Draw mu
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     if priors.rho0 == 0
        Sn(:,1) = (draw.S(n,2:end)' == 0);
        Sn(:,2) = (draw.S(n,2:end)' == 1);
%     else
%         Sn(:,1) = (draw.S(n,1:end)' == 0);
%         Sn(:,2) = (draw.S(n,1:end)' == 1);   
%     end
    Sn_sig = Sn * 1 ./ sqrt(draw.sigsq(n,:));
    
    x = Sn_sig .* Sn;
    if n == 3 && priors.Mex_break == 1
        x = [x, sum(Sn_sig,2).*priors.Dum(2:end,1)];
        m0 = [priors.m0; priors.h0];
        M0 = eye(3);
        M0(1:2,1:2) = priors.M0;
        M0(3,3) = priors.H0;
    else
        M0 = priors.M0;
        m0 = priors.m0;
    end
%     if priors.rho0 == 0
        y = sum(Sn_sig,2) .* (data.x(n,2:end)' - draw.rho(n,1)*data.x(n,1:end-1)');
%     else
%         y = sum(Sn_sig,2) .* data.x(n,1:end)' ;
%     end
    M = inv(inv(M0) + x' * x);
    m = M * (M0 \ m0 + x'*y);
    accept = 0;wait = 1;
    while accept == 0
        mun = m + chol(M)' * normrnd(0,1,size(x,2),1);
        %         if (mun(1,1) > 0) && (mun(2,1) < 0)
        if (mun(1,1) > mun(2,1))
            accept = 1;
            if n == 3 && priors.Mex_break == 1
                mu(n,:) = mun(1:2)';
                h = mun(end);
            else
                mu(n,:) = mun';
            end
        else
            wait = wait + 1;
        end
        if wait > 100
            accept = 1;
            if n == 3 && priors.Mex_break == 1
                mu(n,:) = mu_hold(n,:);
                h = h_hold;
            else
                mu(n,:) = mu_hold(n,:);
            end
        end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Draw rho
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if priors.rho0 == 0
        x = sum(Sn_sig,2) .* (data.x(n,1:end-1)');
        y = sum(Sn_sig,2) .* (data.x(n,2:end)' - Sn * mu(n,:)');
        if n == 3 && priors.Mex_break == 1
            y = y - sum(Sn_sig,2) .* priors.Dum(2:end,1) .* h;
        end
        R = inv(inv(priors.R0) + x' * x);
        r = R * (priors.R0 \ priors.r0 + x'*y);
        accept = 0;wait = 1;
        while accept == 0
            rn = r + chol(R)' * normrnd(0,1,size(x,2),1);
            if abs(rn) < 1
                accept = 1;
                rho(n,:) = rn;
            else
                wait = wait + 1;
            end
            if wait > 100
                accept = 1;
                rho(n,:) = rho_hold(n,:);
            end
        end
    else
        rho = rho_hold;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Draw sigma
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     if priors.rho0 == 0
        e = data.x(n,2:end)' - rho(n,1)*data.x(n,1:end-1)' - Sn * mu(n,:)';
%     else
%        e = data.x(n,1:end)' - Sn * mu(n,:)';
%     end
    if n == 3 && priors.Mex_break == 1
        e = e - priors.Dum(2:end,1) .* h;
    end
    d = priors.d0 + e' * e;
    nu = priors.nu0 + priors.T;
    sigsq(n,:) = inv(gamrnd(nu/2,2/d));
    
end

if priors.Mex_break == 0
    h = 0;
end

end

