function [C,B] = OPS_CB(draw,priors,data)

Bhold = draw.B;
Chold = draw.C;
z = draw.z;

Y = [draw.z; data.y]';
K = size(Y,2);
X = ones(size(Y,1),1);
for p = 1:priors.P
    X = [X,lag0(Y,p)];
end
Y = Y(priors.P + 1 :end,:);
X = X(priors.P + 1:end,:);

T = size(X,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Coefficient Draw
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y = [z; data.y]';
K = size(Y,2);
X = ones(size(Y,1),1);
for p = 1:priors.P
    X = [X,lag0(Y,p)];
end
Y = Y(priors.P + 1 :end,:);
X = X(priors.P + 1:end,:);


b_ols = inv(X'*X)*(X'*Y);
b_ols = b_ols(:);

B1 = inv(inv(priors.B0)+kron(inv(draw.omega),X'*X));
b1 = B1*(inv(priors.B0)*priors.b0 + kron(inv(draw.omega),X'*X)*b_ols);

accept = 0; wait = 0;
while accept == 0
    btemp = b1 + (randn(1,size(b1,1))*chol(B1))';
    CB = reshape(btemp,[],K)';
    C = CB(:,1);
    B = CB(:,2:end);
    % Stationarity Check for B
    F = zeros((priors.N + priors.J) * priors.P,(priors.N + priors.J) * priors.P);
    F(1:K,:) = B;
    for p = 1:priors.P-1
        x_start = K * p + 1;
        x_stop = K * (p + 1);
        y_start = K * (p-1) + 1;
        y_stop = K * p;
        F(x_start:x_stop,y_start:y_stop) = eye(K);
    end
    ee=max(abs(eig(F)));
    S = ee >= 1;
    if S==0
        accept = 1;
    else
        wait = wait + 1;
    end
    if wait > 100
        B = Bhold;
        C = Chold;
        accept = 1;
    end
end





end

