clear all
clc
close all

coh_m2=load('coh_m2.out');
coh_m3=load('coh_m3.out');
coh_m4=load('coh_m4.out');

age_m2=load('age_m2.out');
age_m3=load('age_m3.out');
age_m4=load('age_m4.out');
%%We exclude the last cohort estimates from this exercise because their shares are in fact an outlier (100% share).
figure(1)

        subplot(1,3,1)
        hold on
        plot([25:60],age_m2(:,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{2^{nd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        
        subplot(1,3,2)
        plot([25:60],age_m3(:,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{3^{rd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        %title('age coefficients','FontSize',12,'FontName','Helvetica','Interpreter','latex')
        
         subplot(1,3,3)
        plot([25:60],age_m4(:,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{4^{th}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 

        
   
%sup = suptitle('Figure A.1: Age effects on the distribution of residual household labour income ');
%set(sup,'FontSize',14,'FontWeight','normal')
        
set (figure(1), 'Units', 'normalized', 'Position', [0.16,0,0.8,0.4]);
%set (figure(1), 'Units', 'normalized', 'Position', [0.25,0,0.50,1]);
h = figure(1);
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'Fig_A1','-dpdf','-r600')
print(h,'Fig_A1','-depsc2','-r600')    
        