clear all

local location "C:\Users\spyro\OneDrive - Lancaster University\Submitted_papers_Replication_files\Risk_UK_JAE_Feb_2021" 

**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
*****************                      5. Household Annual Total Earnings                        *********************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
**********************************************************************************************************************
use "`location'\data\main_Y_L_UK.dta", clear

******************************************************************
*******            E5. Estimation of the residuals         *******
******************************************************************
gen y=lY_Lab

xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==1
predict y_resid1 if dum_ed==1, resid
xi: reg y d_sex d_age* d_reg* yrd* i.d_mar*lnumhh if dum_ed==2
predict y_resid2 if dum_ed==2, resid

gen u= .
replace u=y_resid1 if dum_ed==1
replace u=y_resid2 if dum_ed==2


preserve

local var_list = "u"


cap erase "`location'\\Figures\pos_uni_hh_y_x_var_TEMP.dta"
# delimit ;
postfile pfile3 year age coh var ssize mean sd_l m_2 m_3 m_4
			using "`location'\\Figures\pos_uni_hh_y_x_var_TEMP.dta";
# delimit cr



local yr = 1991
while(`yr' <= 2008){
	display("`yr'")
	local age_b = 25
	while(`age_b' <= 60){
		local var_num = 1
		foreach var of local var_list{
			qui sum `var' if year == `yr' & age >= `age_b'-2 & age <= `age_b'+2, detail
			local sd_l       = r(sd)			
            local ssize      = r(N)
			local mean       = r(mean)
			
			qui gen u2=(u-`mean')^2 
			qui gen u3=(u-`mean')^3
			qui gen u4=(u-`mean')^4
			
			qui sum u2 if year == `yr' & age >= `age_b'-2 & age <= `age_b'+2, detail
			local m_2       = r(mean)
			
			qui sum u3 if year == `yr' & age >= `age_b'-2 & age <= `age_b'+2, detail
			local m_3       = r(mean)
			
			qui sum u4 if year == `yr' & age >= `age_b'-2 & age <= `age_b'+2, detail
			local m_4       = r(mean)
			
			drop u2 u3 u4
			
     		post pfile3 (`yr') (`age_b') (`yr'-`age_b') (`var_num') (`ssize') (`mean') (`sd_l') (`m_2') (`m_3') (`m_4')
			local var_num = `var_num' + 1	
		}
		local age_b = `age_b' + 1
	}
	local yr = `yr' + 1		
}

postclose pfile3

		
*******************************************************************************************
//	60:	LABEL THE UNIVARIATE AGE-DIMENSION MOMENTS
*******************************************************************************************

use "`location'\\Figures\pos_uni_hh_y_x_var_TEMP.dta", clear

******** THIS MUST MATCH VAR_LIST ABOVE
label define var_l 1 Y
label values var var_l


// Generate age averages for merging with cohort averages
bys var age: egen sd_l_age_prof = mean(sd_l)

save "`location'\\Figures\pos_uni_hh_y_x_var.dta", replace

unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\pos_uni_hh_y_x_var.out", replace nol non

cap erase "`location'\\Figures\pos_uni_hh_y_x_var_TEMP.dta"


*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	10: CONTROLLING FOR YEAR EFFECTS FOR HOUSEHOLD DATA
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------

use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear


*10.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*10.2:  Generate variance of log 
gen var_l = m_2

*20.3:  Post some data
cap erase "`location'\\Figures\age_m2.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36  using "`location'\\Figures\age_m2.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_age2]) (_b[d_age3]) (_b[d_age4]) (_b[d_age5]) (_b[d_age6]) (_b[d_age7]) (_b[d_age8]) (_b[d_age9]) (_b[d_age10]) (_b[d_age11]) (_b[d_age12]) (_b[d_age13]) (_b[d_age14]) (_b[d_age15]) (_b[d_age16]) (_b[d_age17]) (_b[d_age18]) (_b[d_age19]) (_b[d_age20]) (_b[d_age21]) (_b[d_age22]) (_b[d_age23]) (_b[d_age24]) (_b[d_age25]) (_b[d_age26]) (_b[d_age27]) (_b[d_age28]) (_b[d_age29]) (_b[d_age30]) (_b[d_age31]) (_b[d_age32]) (_b[d_age33]) (_b[d_age34]) (_b[d_age35]) (_b[d_age36])

*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\age_m2.dta", clear

local cc = 2
while(`cc' <= 36){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(age)

label define var_l  1 Y_p
label values var  var_l 

replace age=age+24


*10.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\age_m2.out", replace nol non

save "`location'\\Figures\age_m2.dta", replace


*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	20: CONTROLLING FOR COHORT EFFECTS FOR HOUSEHOLD DATA		
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------

use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear

*20.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*20.2:  Generate variance of log by squaring standard deviation
gen var_l = m_2

*20.3:  Post some data
cap erase "`location'\\Figures\coh_m2.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36 coeff37 coeff38 coeff39 coeff40 coeff41 coeff42 coeff43 coeff44 coeff45 coeff46 coeff47 coeff48 coeff49 coeff50 coeff51 coeff52 coeff53 using "`location'\\Figures\coh_m2.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_coh2]) (_b[d_coh3]) (_b[d_coh4]) (_b[d_coh5]) (_b[d_coh6]) (_b[d_coh7]) (_b[d_coh8]) (_b[d_coh9]) (_b[d_coh10]) (_b[d_coh11]) (_b[d_coh12]) (_b[d_coh13]) (_b[d_coh14]) (_b[d_coh15]) (_b[d_coh16]) (_b[d_coh17]) (_b[d_coh18]) (_b[d_coh19]) (_b[d_coh20]) (_b[d_coh21]) (_b[d_coh22]) (_b[d_coh23]) (_b[d_coh24]) (_b[d_coh25]) (_b[d_coh26]) (_b[d_coh27]) (_b[d_coh28]) (_b[d_coh29]) (_b[d_coh30]) (_b[d_coh31]) (_b[d_coh32]) (_b[d_coh33]) (_b[d_coh34]) (_b[d_coh35]) (_b[d_coh36]) (_b[d_coh37]) (_b[d_coh38]) (_b[d_coh39]) (_b[d_coh40]) (_b[d_coh41]) (_b[d_coh42]) (_b[d_coh43]) (_b[d_coh44]) (_b[d_coh45]) (_b[d_coh46]) (_b[d_coh47]) (_b[d_coh48]) (_b[d_coh49]) (_b[d_coh50]) (_b[d_coh51]) (_b[d_coh52]) (_b[d_coh53])
*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\coh_m2.dta", clear

local cc = 2
while(`cc' <= 53){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(coh)

label define var_l  1 y
label values var  var_l 

replace coh=coh+1931



*20.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\coh_m2.out", replace nol non

save "`location'\\Figures\coh_m2.dta", replace





*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	10: CONTROLLING FOR YEAR EFFECTS FOR HOUSEHOLD DATA
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear


*10.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*10.2:  Generate variance of log 
gen var_l = m_3

*20.3:  Post some data
cap erase "`location'\\Figures\age_m3.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36  using "`location'\\Figures\age_m3.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_age2]) (_b[d_age3]) (_b[d_age4]) (_b[d_age5]) (_b[d_age6]) (_b[d_age7]) (_b[d_age8]) (_b[d_age9]) (_b[d_age10]) (_b[d_age11]) (_b[d_age12]) (_b[d_age13]) (_b[d_age14]) (_b[d_age15]) (_b[d_age16]) (_b[d_age17]) (_b[d_age18]) (_b[d_age19]) (_b[d_age20]) (_b[d_age21]) (_b[d_age22]) (_b[d_age23]) (_b[d_age24]) (_b[d_age25]) (_b[d_age26]) (_b[d_age27]) (_b[d_age28]) (_b[d_age29]) (_b[d_age30]) (_b[d_age31]) (_b[d_age32]) (_b[d_age33]) (_b[d_age34]) (_b[d_age35]) (_b[d_age36])

*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\age_m3.dta", clear

local cc = 2
while(`cc' <= 36){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(age)

label define var_l  1 Y_p
label values var  var_l 

replace age=age+24


*10.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\age_m3.out", replace nol non

save "`location'\\Figures\age_m3.dta", replace


*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	20: CONTROLLING FOR COHORT EFFECTS FOR HOUSEHOLD DATA		
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------

use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear

*20.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*20.2:  Generate variance of log by squaring standard deviation
gen var_l = m_3

*20.3:  Post some data
cap erase "`location'\\Figures\coh_m3.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36 coeff37 coeff38 coeff39 coeff40 coeff41 coeff42 coeff43 coeff44 coeff45 coeff46 coeff47 coeff48 coeff49 coeff50 coeff51 coeff52 coeff53 using "`location'\\Figures\coh_m3.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_coh2]) (_b[d_coh3]) (_b[d_coh4]) (_b[d_coh5]) (_b[d_coh6]) (_b[d_coh7]) (_b[d_coh8]) (_b[d_coh9]) (_b[d_coh10]) (_b[d_coh11]) (_b[d_coh12]) (_b[d_coh13]) (_b[d_coh14]) (_b[d_coh15]) (_b[d_coh16]) (_b[d_coh17]) (_b[d_coh18]) (_b[d_coh19]) (_b[d_coh20]) (_b[d_coh21]) (_b[d_coh22]) (_b[d_coh23]) (_b[d_coh24]) (_b[d_coh25]) (_b[d_coh26]) (_b[d_coh27]) (_b[d_coh28]) (_b[d_coh29]) (_b[d_coh30]) (_b[d_coh31]) (_b[d_coh32]) (_b[d_coh33]) (_b[d_coh34]) (_b[d_coh35]) (_b[d_coh36]) (_b[d_coh37]) (_b[d_coh38]) (_b[d_coh39]) (_b[d_coh40]) (_b[d_coh41]) (_b[d_coh42]) (_b[d_coh43]) (_b[d_coh44]) (_b[d_coh45]) (_b[d_coh46]) (_b[d_coh47]) (_b[d_coh48]) (_b[d_coh49]) (_b[d_coh50]) (_b[d_coh51]) (_b[d_coh52]) (_b[d_coh53])
*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\coh_m3.dta", clear

local cc = 2
while(`cc' <= 53){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(coh)

label define var_l  1 y
label values var  var_l 

replace coh=coh+1931




*20.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\coh_m3.out", replace nol non

save "`location'\\Figures\coh_m3.dta", replace




*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	10: CONTROLLING FOR YEAR EFFECTS FOR HOUSEHOLD DATA
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear


*10.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*10.2:  Generate variance of log 
gen var_l = m_4

*20.3:  Post some data
cap erase "`location'\\Figures\age_m4.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36  using "`location'\\Figures\age_m4.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_age2]) (_b[d_age3]) (_b[d_age4]) (_b[d_age5]) (_b[d_age6]) (_b[d_age7]) (_b[d_age8]) (_b[d_age9]) (_b[d_age10]) (_b[d_age11]) (_b[d_age12]) (_b[d_age13]) (_b[d_age14]) (_b[d_age15]) (_b[d_age16]) (_b[d_age17]) (_b[d_age18]) (_b[d_age19]) (_b[d_age20]) (_b[d_age21]) (_b[d_age22]) (_b[d_age23]) (_b[d_age24]) (_b[d_age25]) (_b[d_age26]) (_b[d_age27]) (_b[d_age28]) (_b[d_age29]) (_b[d_age30]) (_b[d_age31]) (_b[d_age32]) (_b[d_age33]) (_b[d_age34]) (_b[d_age35]) (_b[d_age36])

*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\age_m4.dta", clear

local cc = 2
while(`cc' <= 36){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(age)

label define var_l  1 Y_p
label values var  var_l 

replace age=age+24


*10.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\age_m4.out", replace nol non

save "`location'\\Figures\age_m4.dta", replace


*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*	20: CONTROLLING FOR COHORT EFFECTS FOR HOUSEHOLD DATA		
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------------

use "`location'\\Figures\pos_uni_hh_y_x_var.dta", clear

*20.1:	Generate year, age and cohort dummies
tab age, gen (d_age)
tab coh, gen (d_coh)

drop d_age1
drop d_coh1   //Get rid of a middle cohort

*20.2:  Generate variance of log by squaring standard deviation
gen var_l = m_4

*20.3:  Post some data
cap erase "`location'\\Figures\coh_m4.dta"
postfile pfile var const coeff2 coeff3 coeff4 coeff5 coeff6 coeff7 coeff8 coeff9 coeff10 coeff11 coeff12 coeff13 coeff14 coeff15 coeff16 coeff17 coeff18 coeff19 coeff20 coeff21 coeff22 coeff23 coeff24 coeff25 coeff26 coeff27 coeff28 coeff29 coeff30 coeff31 coeff32 coeff33 coeff34 coeff35 coeff36 coeff37 coeff38 coeff39 coeff40 coeff41 coeff42 coeff43 coeff44 coeff45 coeff46 coeff47 coeff48 coeff49 coeff50 coeff51 coeff52 coeff53 using "`location'\\Figures\coh_m4.dta"


*20.4:  Run the regression and post to the postfile
reg var_l d_coh*  d_age* [aw=ssize]
post pfile (1) (_b[_cons]) (_b[d_coh2]) (_b[d_coh3]) (_b[d_coh4]) (_b[d_coh5]) (_b[d_coh6]) (_b[d_coh7]) (_b[d_coh8]) (_b[d_coh9]) (_b[d_coh10]) (_b[d_coh11]) (_b[d_coh12]) (_b[d_coh13]) (_b[d_coh14]) (_b[d_coh15]) (_b[d_coh16]) (_b[d_coh17]) (_b[d_coh18]) (_b[d_coh19]) (_b[d_coh20]) (_b[d_coh21]) (_b[d_coh22]) (_b[d_coh23]) (_b[d_coh24]) (_b[d_coh25]) (_b[d_coh26]) (_b[d_coh27]) (_b[d_coh28]) (_b[d_coh29]) (_b[d_coh30]) (_b[d_coh31]) (_b[d_coh32]) (_b[d_coh33]) (_b[d_coh34]) (_b[d_coh35]) (_b[d_coh36]) (_b[d_coh37]) (_b[d_coh38]) (_b[d_coh39]) (_b[d_coh40]) (_b[d_coh41]) (_b[d_coh42]) (_b[d_coh43]) (_b[d_coh44]) (_b[d_coh45]) (_b[d_coh46]) (_b[d_coh47]) (_b[d_coh48]) (_b[d_coh49]) (_b[d_coh50]) (_b[d_coh51]) (_b[d_coh52]) (_b[d_coh53])
*20.5:	Close the post file
postclose pfile 


*20.6:	Label the posted data
use "`location'\\Figures\coh_m4.dta", clear

local cc = 2
while(`cc' <= 53){
replace coeff`cc' = coeff`cc' + const
	local cc = `cc' + 1		
}

rename const coeff1

reshape long coeff, i(var) j(coh)

label define var_l  1 y
label values var  var_l 

replace coh=coh+1931



*20.8:	Export for use in Matlab
unab varlist: *
foreach var2 of varlist `varlist'{
	replace `var2' = -99999 if `var2' == .
}
outsheet using "`location'\\Figures\coh_m4.out", replace nol non

save "`location'\\Figures\coh_m4.dta", replace



