
*********************************************************
************       1_merge_data_91_09      **************
*********************************************************

/*****************APPEND INFORMATION FROM ALL WAVES***************************/
/*******************************************************************************************/

clear

set more off

local location "C:\Users\spyro\OneDrive - Lancaster University\Submitted_papers_Replication_files\Risk_UK_JAE_Feb_2021" 

***** 1. insert above the directory of the main folder with the raw data (here denoted as BHPS 1991-2009)
***** 2. put in the "raw_data" folder the datasets: i) UKDA-5151 ii) UKDA-3909 (they can be dowloade by the UK Dataservice) 
***** 3. Saves temporary files in the "temp" folder
***** 4. Saves the panel dataset in the "data" folder


******************************************
local w=1

foreach wave in a b c d e f g h i j k l m n o p q r{

*	-------------------- INDRESP ---------------------------------------
	use "`location'\\raw_data\UKDA-5151-stata\stata\stata13\bhps_w`w'\\`wave'indresp.dta", clear
	
		
	if("`wave'" != "h")	local rename `wave'hid hid
	renpfix `wave' 
	if("`wave'" == "p") rename id pid
	sort pid
	save "`location'\temp\temp1.dta", replace
* 	----------------------------------------------------------------------------


* 	------------------- INCOME -------------------------------------------------
	use "`location'\\raw_data\UKDA-5151-stata\stata\stata13\bhps_w`w'\\`wave'indall.dta", clear

	if ("`wave'" == "a") gen ahhyoi4 = 1991
    if("`wave'" != "h")	local rename `wave'hid hid
	*keep everything
	renpfix `wave' 
	if("`wave'" == "p")	rename id pid
    sort pid
	save "`location'\temp\temp2.dta",replace  
*	----------------------------------------------------------------------------


* 	------------------- NET FAMILY INCOME --------------------------------------
	use "`location'\\raw_data\UKDA-3909-stata10\stata10\dacurrent/`wave'_NETHH.dta", clear
	
	if("`wave'" != "h")	local rename `wave'hid hid
	
	renpfix `wave' 
		
	sort hid
	save "`location'\temp\temp3.dta",replace 
	
* 	----------------------------------------------------------------------------

	
* 	------------------- HOUSEHOLD STRUCTURE ------------------------------------
	use "`location'\\raw_data\UKDA-5151-stata\stata\stata13\bhps_w`w'\\`wave'hhresp.dta", clear
	
	if("`wave'" == "a")	local sampweight = "ahhwght"

	if("`wave'" != "a")	local sampweight = "`wave'xhwght"
	
	if("`wave'" != "h")	local rename `wave'hid hid
	
	renpfix `wave' 
	
	sort hid
	save "`location'\temp\temp4.dta",replace 
* 	----------------------------------------------------------------------------

* 	------------------- NET FAMILY INCOME --------------------------------------
	use "`location'\\raw_data\UKDA-5151-stata\stata\stata13\bhps_w`w'\\`wave'hhsamp.dta", clear
	if("`wave'" != "a")	local rename `wave'hid 1hid
	if("`wave'" != "h")	local rename `wave'hid hid
	
	renpfix `wave' 
		
	sort hid
	save "`location'\temp\temp5.dta",replace 
	
* 	----------------------------------------------------------------------------

* 	------------------- NET FAMILY INCOME --------------------------------------
	use "`location'\\raw_data\UKDA-3909-stata10\stata10\daannual/`wave'_neta.dta", clear
	
	if("`wave'" != "h")	local rename `wave'hid hid
	
	renpfix `wave' 
		
	sort hid
	save "`location'\temp\temp6.dta",replace 
	
* 	----------------------------------------------------------------------------

* 	----------------------------------------------------------------------------

* 	-------------------------  Merge the datasets-------------------------------
	use "`location'\temp\temp1.dta"
	merge 1:1 pid using "`location'\temp\temp2.dta"
	drop if _m<3   /* This drops proxy respondents etc. */
	drop _merge
	

	sort hid		
	merge m:1 hid using "`location'\temp\temp3.dta"
	drop if _m==2  
	drop _merge
	
				
	sort hid		
	merge m:1 hid using "`location'\temp\temp4.dta"
	drop if _m==2  
	drop _merge
		
	sort hid		
	merge m:1 hid using "`location'\temp\temp5.dta"
	drop if _m==2  
	drop _merge	
	
	sort hid		
	merge m:1 hid using "`location'\temp\temp6.dta"
	drop if _m==2  
	drop _merge	
	
	gen year =. 
	replace year=1991 if "`wave'"=="a"
	replace year=1992 if "`wave'"=="b"
	replace year=1993 if "`wave'"=="c"
	replace year=1994 if "`wave'"=="d"
	replace year=1995 if "`wave'"=="e"
	replace year=1996 if "`wave'"=="f"
	replace year=1997 if "`wave'"=="g"
	replace year=1998 if "`wave'"=="h"
	replace year=1999 if "`wave'"=="i"
	replace year=2000 if "`wave'"=="j"
	replace year=2001 if "`wave'"=="k"
	replace year=2002 if "`wave'"=="l"
	replace year=2003 if "`wave'"=="m"
	replace year=2004 if "`wave'"=="n"
	replace year=2005 if "`wave'"=="o"
	replace year=2006 if "`wave'"=="p"
	replace year=2007 if "`wave'"=="q"
	replace year=2008 if "`wave'"=="r"
	
	save "`location'\temp\yr`wave'.dta", replace
	
	local w=`w'+1
	
}
cap erase "`location'\temp\temp1.dta"
cap erase "`location'\temp\temp2.dta"
cap erase "`location'\temp\temp3.dta"
cap erase "`location'\temp\temp4.dta" 
cap erase "`location'\temp\temp5.dta"
cap erase "`location'\temp\temp6.dta" 
/*********** LONG FORM ********/


/* 1. appending single years */

use "`location'\temp\yra.dta", replace
foreach wave in b c d e f g h i j k l m n o p q r{
	append using "`location'\temp\yr`wave'.dta"
}

sort pid year
save "`location'\data\paneldataBHPSimp.dta", replace

foreach wave in a b c d e f g h i j k l m n o p q r{
	cap erase "`location'\temp\yr`wave'.dta"
}





