%% Replication code
% Giovanni Angelini, Giuseppe Cavaliere, and Luca Fanelli
% Bootstrap Inference and Diagnostic in State Space Models: with Applications to Dynamic Macro Models
% Journal of Applied Econometrics.

% This code estimates the DSGE model described in Section 5.1 of the paper.

clear
clc
close all

addpath Functions
addpath Data

%% *************** Global variables ***************

global observable_variables
global M
global t_outer

global sigma 
% global alpha 
global beta 
global phi_pi
global phi_x 
global omega
global rho_r 
global rho_z 
global theta
global sigma_z
global sigma_r 


%% *************** Model parameters **************

sigma = 1;
alpha = 0.75;
beta = 0.99;
omega = 1;
rho_z = 0.90;
theta = 6;
sigma_z = 0.30;
sigma_r = 0.20;
kappa =( ((1-alpha)*(1-alpha*beta))/alpha )*( (omega+sigma)/(sigma*(omega+theta)));
phi_pi = 1.5;
phi_x = 0.125;
rho_r = 0.75;

bounds_alpha=[0.01 0.999];
teta=[alpha]; 
SIGMA=diag([sigma_z,sigma_r]);

NBoot=1999; % Bootstrap iteration
options = optimset('TolFun',1e-5,'MaxIter',1e5,'MaxFunEvals', 1e5);

Bounds = zeros(size(teta,2),2);
Bounds(1,:)=bounds_alpha;

teta_init = teta;

%% *************** Upload dataset ************** 

filename = 'Dataset.xls';
xlsRange = 'B2:C99';
Dataset = xlsread(filename,xlsRange);


M = 2;

MeanDATA= repmat(mean(Dataset,1),size(Dataset,1),1);  
observable_variables=Dataset- MeanDATA;

observable_variables_sample = observable_variables;

T=size(observable_variables,1);

%% *************** Estimate ************** 

[StoreESTIMATIONS_UNREST, StoreLIKELIHOOD_UNREST,exitflag,output,lambda,grad,Hessian_UNREST] = fmincon('GQ_logLK',teta_init,[],[],[],[],Bounds(:,1),Bounds(:,2),[],options);
StoreSEHess_UNREST=(diag(inv(Hessian_UNREST)).^0.5);

BoundsG = [StoreESTIMATIONS_UNREST StoreESTIMATIONS_UNREST];
grad_op=[];
for t_outer_ = 2 : T
t_outer = t_outer_;
[StoreESTIMATIONS_UNRESTG, StoreLIKELIHOOD_UNRESTG,exitflagG,outputG,lambdaG,grad_op(:,t_outer)] = fmincon('GQ_logLK_OuterProduct',StoreESTIMATIONS_UNREST,[],[],[],[],BoundsG(:,1),BoundsG(:,2),[],options);
end

OP_grad=grad_op*grad_op';
I_theta_tilde =  Hessian_UNREST * OP_grad^(-1) * Hessian_UNREST;
StoreSE_OP=(diag(inv(I_theta_tilde)).^0.5);

[StoreEpsilonOLD, StoreSigma, StoreSTD, StoreZeta, StoreZeta10, StoreKalman]=GQ_innovationsKF(StoreESTIMATIONS_UNREST);
StoreEpsilon=StoreSTD-repmat(mean(StoreSTD),size(StoreSTD,1),1);

[PROBLEM_boot, CC_boot, HH_boot]=GQ_Solution(StoreESTIMATIONS_UNREST); 

pigreco=1;
r=2;
y=3;
z=4;

A_boot=CC_boot([r z],[r z]);
B_boot=HH_boot([r z],:);
C_boot=CC_boot([pigreco r],[r z]);
D_boot=HH_boot([pigreco r],:);

H_boot=C_boot*inv(A_boot);
Q_boot=-(C_boot*inv(A_boot)*B_boot)+D_boot;

x_old=observable_variables(1,:)';

%% *************** Bootstrap ************** 

    for boot = 1 : NBoot
    tic
    boot
    ControlSE_Boot = 1;

        while ControlSE_Boot == 1

        TimeSampleBootstrap=datasample(round(T/10,0):T,T)';
        ErrorSampleBoot=StoreEpsilon(TimeSampleBootstrap,:)';
        SigmaSampleBoot=StoreSigma(:,:,TimeSampleBootstrap);
        KamlmaSampleBoot=StoreKalman(:,:,TimeSampleBootstrap);

        state_variables_boot=[];
        observable_variables_boot=x_old';

            for t=2:T  
            x=A_boot*x_old+A_boot*KamlmaSampleBoot(:,:,t)*SigmaSampleBoot(:,:,t)^0.5*ErrorSampleBoot(:,t);
            x_obs=H_boot*x_old+SigmaSampleBoot(:,:,t)^0.5*ErrorSampleBoot(:,t);
            union=[x; x_old];
            x_old=union(1:M,1);
            state_variables_boot=[state_variables_boot;x'];
            observable_variables_boot=[observable_variables_boot; x_obs'];
            end   

        observable_variables=observable_variables_boot;
        options = optimset('TolFun',1e-2,'MaxIter',1e3,'MaxFunEvals', 1e3);
       [BOOT_StoreESTIMATIONS_UNREST(boot,:), BOOT_StoreLIKELIHOOD_UNREST(boot,:),exitflag,output,lambda,grad,BOOT_Hessian_UNREST(:,:,boot)] = fmincon('GQ_logLK',StoreESTIMATIONS_UNREST,[],[],[],[],Bounds(:,1),Bounds(:,2),[],options); 
        I_theta = BOOT_Hessian_UNREST(:,:,boot);
        BOOT_StoreSE_UNREST_Hess(boot,:)=(diag(inv(I_theta)).^0.5);

        BOOT_BoundsG = [BOOT_StoreESTIMATIONS_UNREST(boot,:)' BOOT_StoreESTIMATIONS_UNREST(boot,:)'];
        BOOT_grad_op=[];
            for t_outer_ = 2 : T
            t_outer = t_outer_;
            [BOOT_StoreESTIMATIONS_UNRESTG, BOOT_StoreLIKELIHOOD_UNRESTG,exitflagG,outputG,lambdaG,BOOT_grad_op(:,t_outer)] = fmincon('GQ_logLK_OuterProduct',BOOT_StoreESTIMATIONS_UNREST(boot,:),[],[],[],[],BOOT_BoundsG(:,1),BOOT_BoundsG(:,2),[],options);
            end            

        BOOT_OP_grad=BOOT_grad_op*BOOT_grad_op';
        BOOT_I_theta_tilde =  BOOT_Hessian_UNREST(:,:,boot) * BOOT_OP_grad^(-1) * BOOT_Hessian_UNREST(:,:,boot)';
        BOOT_StoreSE_OP(boot,:)=(diag(inv(BOOT_I_theta_tilde)).^0.5);    
        
        LimitSE_Max = 500;
        LimitSE_Min = 0.0001;
        
            if sum(BOOT_StoreSE_UNREST_Hess(boot,:)>LimitSE_Max)==0 && sum(BOOT_StoreSE_UNREST_Hess(boot,:)<LimitSE_Min)==0
            ControlSE_Boot = 0;    
            end
                      
        end
        toc

    end
    
%% *************** Save results **************     

NParam = size(teta,2);
TodayIter = today;
Name=sprintf('Alpha_GQ_T%.0f_B%.0f_Param%.0f_Day%.0f',T,NBoot,NParam,TodayIter);
save(Name)
