function [StoreEpsilon, StoreSIGMA, StoreEpsilonStandard, StoreZeta, StoreZeta10, StoreP]=GQ_innovationsKF(PE0)

global observable_variables
global M
global sigma_z
global sigma_r

[PROBLEM, CC, HH]=GQ_Solution(PE0);
SIGMA=diag([sigma_z,sigma_r]);

    if PROBLEM 
    lik=+10000000;
    else

    % Variable Number
    pigreco=1;
    r=2;
    x=3;
    z=4;
    csi=5;

    AA=CC([r z],[r z]);
    BB=HH([r z],:);
    CC=CC([pigreco r],[r z]);
    DD=HH([pigreco r],:);

    B=AA;
    Q1=BB;
    H=CC*inv(AA);
    Q2=-CC*inv(AA)*BB+DD;

    % Measurement Error
    SigmaV=Q2*SIGMA*Q2';
    % State Error
    SigmaW=Q1*SIGMA*Q1';    
    
    y=observable_variables;
    T=size(y,1);
    StoreEpsilon=[];
    StoreEpsilonStandard=[];
    StoreZeta=[];
    StoreZeta10=[];
    StoreSIGMA=zeros(2,2,T);
    StoreP=zeros(M,2,T);

    % Start KF Iteration
    lik=0;
    %filter
    zeta0=zeros(1,M);
    SigmaZ=eye(M);
    % beta_tt=[];
    ptt=zeros(T,M,M);
    % StoreSigmaZeta=zeros(p*M,p*M,T);
    % StoreKalmanGain=zeros(p*M,p*M,T);
    i=1;
    r=0;
    %Prediction
    zeta10=zeta0*B';
    StoreZeta10=[StoreZeta10; zeta10];
    SigmaZ10=B*SigmaZ*B'+SigmaW;
    yhat=(H*(zeta10)')';                                                
    epsilon=y(i,:)-yhat;
    SigmaY=(H*SigmaZ10*H')+SigmaV;
    %updating
    P=(SigmaZ10*H')*inv(SigmaY); % Kalman Gain
    StoreP(:,:,i)=P;
    zeta11=(zeta10'+P*epsilon')';
    SigmaZ11=SigmaZ10-P*(SigmaY)*P';
    % beta_tt=[beta_tt;beta11];
    ptt(i,:,:)=SigmaZ11;
    % 
    epsilonstd=(SigmaY)^(-0.5)*epsilon';
    % epsilonstd=chol(SigmaY)*epsilon';
    StoreEpsilon=[StoreEpsilon; epsilon];
    StoreEpsilonStandard=[StoreEpsilonStandard; epsilonstd'];
    % StoreEpsilonStandard1=[StoreEpsilonStandard1; epsilonstd1'];
    StoreSIGMA(:,:,i)=SigmaY;
    StoreZeta=[StoreZeta; zeta11];
    % StoreZetaPred=[StoreZetaPred; zeta10];
    % StoreSigmaZeta(:,:,i)=SigmaZ11;
    % StoreKalmanGain(:,:,i)=P;
    
        for i=2:T
        %Prediction
        zeta10=zeta11*B';
        StoreZeta10=[StoreZeta10; zeta10];
        SigmaZ10=B*SigmaZ11*B'+SigmaW;
        yhat=(H*(zeta10)')';%+INTERCEPT;                                                
        epsilon=y(i,:)-yhat;
        SigmaY=(H*SigmaZ10*H')+SigmaV;
        %updating
        P=(SigmaZ10*H')*inv(SigmaY);
        StoreP(:,:,i)=P;
        zeta11=(zeta10'+P*epsilon')';
        SigmaZ11=SigmaZ10-P*(H*SigmaZ10);
        % beta_tt=[beta_tt;beta11];
        ptt(i,:,:)=SigmaZ11;

        epsilonstd=(SigmaY)^(-0.5)*epsilon';
        % epsilonstd=chol(SigmaY)*epsilon';
        StoreEpsilon=[StoreEpsilon; epsilon];
        StoreEpsilonStandard=[StoreEpsilonStandard; epsilonstd'];
        % StoreEpsilonStandard1=[StoreEpsilonStandard1; epsilonstd1'];
        StoreSIGMA(:,:,i)=SigmaY;
        StoreZeta=[StoreZeta; zeta11];
        % StoreZetaPred=[StoreZetaPred; zeta10];
        % StoreSigmaZeta(:,:,i)=SigmaZ11;
        % StoreKalmanGain(:,:,i)=P;
        end

    end
end
