%% This code replicates the results in Figure 2 and Table 3 of the paper: 
% Giovanni Angelini, Giuseppe Cavaliere, and Luca Fanelli
% Bootstrap Inference and Diagnostic in State Space Models: with Applications to Dynamic Macro Models
% Journal of Applied Econometrics, forthcoming.

clear
clc
close all

addpath Functions
addpath Functions\fanchart

% ****** Upload here the name of the file with the estimates

% load Alpha_GQ_T98_B9_Param1_Day738314
load Alpha_GQ_T98_B1999_Param1

% ******

FontSizeGraph = 20;

% BOOT_StoreSE_OP = BOOT_StoreSE_UNREST_Hess;
% StoreSE_OP = StoreSEHess_UNREST;
 
BOOT_Mean = mean(BOOT_StoreESTIMATIONS_UNREST,1);
BOOT_SE = median(BOOT_StoreSE_OP,1);

NBoot = size(BOOT_StoreESTIMATIONS_UNREST,1);

BTildeVEC = [1/2*T^(4/5) 1/3*T^(4/5)];

LineWidth = 6;
%% *************************************** Figure 2 (left panel) ***************************************

Begin = 50;
ParamFigure = 1;
pd_boot = makedist('Normal',BOOT_Mean(ParamFigure),mean(BOOT_StoreSE_UNREST_Hess(:,ParamFigure))); 
pd_sample = makedist('Normal',StoreESTIMATIONS_UNREST(ParamFigure),StoreSEHess_UNREST(ParamFigure));
EstBoot  = (BOOT_StoreESTIMATIONS_UNREST(Begin:Begin+1/2*T^(4/5),:));
x = 0.77:0.001:0.85;
cdf_normal_boot = cdf(pd_boot,x);
cdf_normal_sample = cdf(pd_sample,x);
figure(1)
subplot(2,1,1)
[EmpiricalCdf_f EmpiricalCdf_x] = ecdf(EstBoot(:,ParamFigure));
plot(EmpiricalCdf_x,EmpiricalCdf_f,'LineWidth',LineWidth)
set(gca,'FontSize',FontSizeGraph);
hold all
plot(x,cdf_normal_boot,'k--','LineWidth',LineWidth)
hold all
plot(x,cdf_normal_sample,'r--','LineWidth',LineWidth)
subplot(2,1,2)
set(gca,'FontSize',FontSizeGraph);
x = 0.77:0.001:0.85
cdf_normal_boot = pdf(pd_boot,x);
cdf_normal_sample = pdf(pd_sample,x);
[f,xi] = ksdensity(EstBoot(:,ParamFigure)); 
plot(xi,f,'LineWidth',LineWidth);
hold all
plot(x,cdf_normal_boot,'k--','LineWidth',LineWidth)
plot(x,cdf_normal_sample,'r--','LineWidth',LineWidth)
set(gca,'FontSize',FontSizeGraph);

%% *************************************** Table 3  (upper panel) ***************************************

% ***** Misspecification test *****

LimitTest=0.05;

for btilde = 1 : size(BTildeVEC,2)
BTilde=round(BTildeVEC(btilde));
NBlocks = floor(NBoot/BTildeVEC(btilde))-1;
AlphaCorrected = 1-(1-LimitTest)^(1/NBlocks);
StoreALPHA(:,btilde)=AlphaCorrected;
end

for btilde = 1 : size(BTildeVEC,2)
    BTilde=round(BTildeVEC(btilde));
    NBlocks = floor(NBoot/BTildeVEC(btilde))-2;    
        
        try
        [PA_UNREST, DornikHansen_Original(1,btilde)] = DorHanomunortest(BOOT_StoreESTIMATIONS_UNREST(1+Begin:BTilde+Begin,:,1),LimitTest);   
        catch
        DornikHansen_Original(1,btilde)=0;
        end

        [h JarqueBera_tao_Original(1,btilde)]=jbtest(BOOT_StoreESTIMATIONS_UNREST(1+Begin:BTilde+Begin,1,1),...
                                             LimitTest,0.001);    
        [h ShapiroWilk_tao_Original(1,btilde)]=swtest(BOOT_StoreESTIMATIONS_UNREST(1+Begin:BTilde+Begin,1,1),LimitTest);

        
end

DornikHansen_Original;
JarqueBera_tao_Original;
ShapiroWilk_tao_Original;

% ***** Estiamtes *****

LimSup = 95;
LimInf = 5;
ValueALFA=0.1; 
pd = makedist('Normal');
Z_Alpha = abs(icdf(pd,ValueALFA/2));

TetaEst = (StoreESTIMATIONS_UNREST);
Store_SE=abs(StoreSE_OP);
SeEst = (Store_SE);
EstIter_Inf = StoreESTIMATIONS_UNREST - Z_Alpha * Store_SE;
EstIter_Sup = StoreESTIMATIONS_UNREST + Z_Alpha * Store_SE;

TetaBoot = mean(BOOT_StoreESTIMATIONS_UNREST);
Store_SE_BOOT=abs(BOOT_StoreSE_OP);
SeBoot = median(Store_SE_BOOT);

z_series = (BOOT_StoreESTIMATIONS_UNREST -  repmat(StoreESTIMATIONS_UNREST,NBoot,1) ) ./ Store_SE_BOOT;

EstIter_InfBoot = StoreESTIMATIONS_UNREST + prctile(z_series,LimInf) .* Store_SE;
EstIter_SupBoot = StoreESTIMATIONS_UNREST + prctile(z_series,LimSup) .* Store_SE;

% ***** Summary Table 3 *****

clc

data = round([TetaEst SeEst EstIter_Inf EstIter_Sup ...
 TetaBoot SeBoot EstIter_InfBoot EstIter_SupBoot ...
 DornikHansen_Original(2) DornikHansen_Original(1) ...
 JarqueBera_tao_Original(2) JarqueBera_tao_Original(1) ...
 ShapiroWilk_tao_Original(2) ShapiroWilk_tao_Original(1)],2);

% Create a table
% h={'hat_theta' 's.e.(hat_theta)' '90%-CI lb' '90%-CI up' ...
%     'hat_theta*' 's.e.(hat_theta*)' '90%-BSCI lb' '90%-BSCI ub' ...
%     'DH (1/3)' 'DH (1/2)' 'JB (1/3)' 'JB (1/2)' 'Sw (1/3)' 'SW (1/2)'}
% 
% f=figure;
% t=uitable(f,'data',data,'columnname',h)
% t.Position = [250 300 840 60];

fprintf('hat_theta s.e.(hat_theta) 90-CI(lb) 90-CI(up) hat_theta* s.e.(hat_theta*) 90-BSCI(lb) 90-BSCI(ub)\n')
disp(data(1:8))

fprintf('DH(1/3) DH(1/2) JB(1/3) JB(1/2) Sw(1/3) SW(1/2)\n')
disp(data(9:14))

