* simulation exercise for US

cap log close
log using $log\7_simulation_dgp_us.txt, replace text

clear all
set seed 083834

* dgp for the US
set obs 69000
gen selector = runiform()

gen m1 = . 
replace m1 = rbeta(4,7) if inrange(selector,0.15,0.95)
replace m1 = rbeta(1,15) if inrange(selector,0,0.15)
replace m1 = rbeta(8,1) if inrange(selector,0.95,1)


label variable m1 "simulated US density"


cap drop Xj Yj r0 fhat se_fhat
DCdensityRR m1, b(0.01) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) 
graph export $log\7_FigureA1_sim_us_McC.pdf, as(pdf) replace

* Simulation excercise
	cap program drop sim_us
    program define sim_us, rclass
        version 9.0  // as used in DCdensity
        
		* Create dataset 
		drop _all
		set obs 69000
		gen selector = runiform()

		gen m1 = . 
		replace m1 = rbeta(4,7) if inrange(selector,0.15,0.95)
		replace m1 = rbeta(1,15) if inrange(selector,0,0.15)
		replace m1 = rbeta(8,1) if inrange(selector,0.95,1)

		
		* Run estimations with mass points of different size
			foreach mass of numlist 0 20 50 100 200  {    //
			
			local now_obs = 69000 + `mass'
			set obs `now_obs'
			replace m1 = 0.5 if m1 == .

			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1, b(0.05) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_05_`mass' = r(theta) / r(se)
		
			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1, b(0.01) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_01_`mass' = r(theta) / r(se)
		
			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1,  breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_def_`mass' = r(theta) / r(se)
		
			rddensity m1, c(0.500001) 
			scalar CJM_T_`mass' = (e(f_qr)-e(f_ql) )/e(se_q)
			}
		

		* Post results (t-values)
			foreach mass of numlist 0 20 50 100 200  {    //
			return scalar McC_T_05_`mass'	= McC_T_05_`mass'
			return scalar McC_T_01_`mass' 	= McC_T_01_`mass'
			return scalar McC_T_def_`mass'	= McC_T_def_`mass'
			return scalar CJM_T_`mass'		= CJM_T_`mass' 
			}
	end

 simulate , reps($reps): sim_us
	
save $data\7_sim_us_results, replace

	foreach var of varlist _all {
	disp "*** `var'"	
	count if abs(`var') > 1.96
	}
		
log close
