* simulation exercise for West Germany

cap log close
log using $log\5_simulation_dgp_west.txt, replace text

clear all
set seed 182304

* dgp for West Germany
set obs 70000
gen selector = runiform()

gen m1 = . 
replace m1 = rbeta(7,15) if inrange(selector,0,0.7)
replace m1 = rbeta(34,36) if inrange(selector,.7,.95)
replace m1 = rbeta(7,4) if inrange(selector,0.95,1)


label variable m1 "simulated West German density"


cap drop Xj Yj r0 fhat se_fhat
DCdensityRR m1, b(0.01) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) 
graph export $log\5_FigureA1_sim_west_McC.pdf, as(pdf) replace

* Simulation excercise
	cap program drop sim_west
    program define sim_west, rclass
        version 9.0  // as used in DCdensity

		* Create dataset 
		drop _all
        set obs 70000
		gen selector = runiform()

		gen m1 = . 
		replace m1 = rbeta(7,15) if inrange(selector,0,0.7)
		replace m1 = rbeta(34,36) if inrange(selector,.7,.95)
		replace m1 = rbeta(7,4) if inrange(selector,0.95,1)

		
		* Run estimations with mass points of different size
			foreach mass of numlist 0 20 50 100 200  {    //
			
			local now_obs = 70000 + `mass'
			set obs `now_obs'
			replace m1 = 0.5 if m1 == .

			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1, b(0.05) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_05_`mass' = r(theta) / r(se)
		
			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1, b(0.01) breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_01_`mass' = r(theta) / r(se)
		
			cap drop Xj Yj r0 fhat se_fhat
			DCdensityRR m1,  breakpoint(0.500001) generate(Xj Yj r0 fhat se_fhat) nograph
			scalar McC_T_def_`mass' = r(theta) / r(se)
		
			rddensity m1, c(0.500001) 
			scalar CJM_T_`mass' = (e(f_qr)-e(f_ql) )/e(se_q)
			}
		

		* Post results (t-values)
			foreach mass of numlist 0 20 50 100 200  {    //
			return scalar McC_T_05_`mass'	= McC_T_05_`mass'
			return scalar McC_T_01_`mass' 	= McC_T_01_`mass'
			return scalar McC_T_def_`mass'	= McC_T_def_`mass'
			return scalar CJM_T_`mass'		= CJM_T_`mass' 
			}
	end

 simulate , reps($reps): sim_west
	
save $data\5_sim_west_results, replace

	foreach var of varlist _all {
	disp "*** `var'"	
	count if abs(`var') > 1.96
	}
	
log close
