
********************************************************************************
/*	 
	 Revisiting Gender Identity and Relative Income within Households –
	A cautionary tale on the potential pitfalls of density estimators.

		Daniel Kuehnle, Michael Oberfichtner, Kerstin Ostermann
						 Last update: March 2021
								
					Master Dofile for the German analyses
						
*******************************************************************************/
//set up
clear all
version 14.2
 
set rmsg on
set varabbrev off

//Define paths
global project 	"PATH NAME"
global log 	"$project\log"  	// log-files etc. will be stored here
global prog	"$project\prog"		// folder contains all do-files
global orig	"$project\orig"		// folder contains original data before preparation steps
global data	"$project\data"		// intermediate datasets will be stored here

cd $project

adopath ++ "ado" 	// folder contains additional do-files

*******************************************************************************

//data prepartion 
do $prog\1_paar_ids.do
do $prog\2_merge.do

//analysis of German data (Values for Table 1 and Figure 2)
do $prog\3_analysis.do

//investigate the cutoff (panels of Figure 3)
do $prog\4_figure3.do

//Simulation
global reps 2000 // number of replications

*generate data for Table 2 and graphs for Figure A.1
do $prog\5_simulation_dgp_west.do
do $prog\6_simulation_dgp_east.do
do $prog\7_simulation_dgp_us.do

*generate Table 2
do $prog\8_simulation_dgp_tables.do
